<?php
/*
Plugin Name: TheAisle Instagram Feed
Plugin URI: https://qodeinteractive.com
Description: Plugin that adds Instagram feed functionality to our theme
Author: Elated Themes
Author URI: https://qodeinteractive.com
Version: 2.2.2
*/
define( 'THEAISLE_INSTAGRAM_FEED_VERSION', '2.2.2' );
define( 'THEAISLE_INSTAGRAM_ABS_PATH', dirname( __FILE__ ) );
define( 'THEAISLE_INSTAGRAM_REL_PATH', dirname( plugin_basename( __FILE__ ) ) );
define( 'THEAISLE_INSTAGRAM_URL_PATH', plugin_dir_url( __FILE__ ) );
define( 'THEAISLE_INSTAGRAM_ASSETS_PATH', THEAISLE_INSTAGRAM_ABS_PATH . '/assets' );
define( 'THEAISLE_INSTAGRAM_ASSETS_URL_PATH', THEAISLE_INSTAGRAM_URL_PATH . 'assets' );
define( 'THEAISLE_INSTAGRAM_SHORTCODES_PATH', THEAISLE_INSTAGRAM_ABS_PATH . '/shortcodes' );
define( 'THEAISLE_INSTAGRAM_SHORTCODES_URL_PATH', THEAISLE_INSTAGRAM_URL_PATH . 'shortcodes' );

include_once 'load.php';

if ( ! function_exists( 'theaisle_instagram_theme_installed' ) ) {
	/**
	 * Checks whether theme is installed or not
	 * @return bool
	 */
	function theaisle_instagram_theme_installed() {
		return defined( 'ELATED_ROOT' );
	}
}

if ( ! function_exists( 'theaisle_instagram_feed_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function theaisle_instagram_feed_text_domain() {
		load_plugin_textdomain( 'theaisle-instagram-feed', false, THEAISLE_INSTAGRAM_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'theaisle_instagram_feed_text_domain' );
}