<?php

foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/blog/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'theaisle_elated_map_blog_meta' ) ) {
	function theaisle_elated_map_blog_meta() {
		$eltdf_blog_categories = array();
		$categories           = get_categories();
		foreach ( $categories as $category ) {
			$eltdf_blog_categories[ $category->slug ] = $category->name;
		}
		
		$blog_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'page' ),
				'title' => esc_html__( 'Blog', 'theaisle' ),
				'name'  => 'blog_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_category_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Blog Category', 'theaisle' ),
				'description' => esc_html__( 'Choose category of posts to display (leave empty to display all categories)', 'theaisle' ),
				'parent'      => $blog_meta_box,
				'options'     => $eltdf_blog_categories
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_show_posts_per_page_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Posts', 'theaisle' ),
				'description' => esc_html__( 'Enter the number of posts to display', 'theaisle' ),
				'parent'      => $blog_meta_box,
				'options'     => $eltdf_blog_categories,
				'args'        => array(
					'col_width' => 3
				)
			)
		);

        theaisle_elated_create_meta_box_field(
            array(
                'name'        => 'eltdf_blog_standard_layout_meta',
                'type'        => 'select',
                'label'       => esc_html__( 'Standard - Layout', 'theaisle' ),
                'description' => esc_html__( 'Set standard layout. Default is left aligned.', 'theaisle' ),
                'parent'      => $blog_meta_box,
                'options'     => array(
                    ''           => esc_html__( 'Default', 'theaisle' ),
                    'left-aligned'    => esc_html__( 'Left Aligned', 'theaisle' ),
                    'center-aligned' => esc_html__( 'Center Aligned', 'theaisle' )
                )
            )
        );
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_masonry_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Layout', 'theaisle' ),
				'description' => esc_html__( 'Set masonry layout. Default is in grid.', 'theaisle' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''           => esc_html__( 'Default', 'theaisle' ),
					'in-grid'    => esc_html__( 'In Grid', 'theaisle' ),
					'full-width' => esc_html__( 'Full Width', 'theaisle' )
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_masonry_number_of_columns_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Number of Columns', 'theaisle' ),
				'description' => esc_html__( 'Set number of columns for your masonry blog lists', 'theaisle' ),
				'parent'      => $blog_meta_box,
				'options'     => theaisle_elated_get_number_of_columns_array( true, array( 'one', 'six' ) )
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_masonry_space_between_items_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Space Between Items', 'theaisle' ),
				'description' => esc_html__( 'Set space size between posts for your masonry blog lists', 'theaisle' ),
				'options'     => theaisle_elated_get_space_between_items_array( true ),
				'parent'      => $blog_meta_box
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_list_featured_image_proportion_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'theaisle' ),
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'theaisle' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''         => esc_html__( 'Default', 'theaisle' ),
					'fixed'    => esc_html__( 'Fixed', 'theaisle' ),
					'original' => esc_html__( 'Original', 'theaisle' )
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_pagination_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'theaisle' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'theaisle' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''                => esc_html__( 'Default', 'theaisle' ),
					'standard'        => esc_html__( 'Standard', 'theaisle' ),
					'load-more'       => esc_html__( 'Load More', 'theaisle' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'theaisle' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'theaisle' )
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'type'          => 'text',
				'name'          => 'eltdf_number_of_chars_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'theaisle' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'theaisle' ),
				'parent'        => $blog_meta_box,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_blog_meta', 30 );
}