<?php

if ( ! function_exists( 'theaisle_elated_map_post_audio_meta' ) ) {
	function theaisle_elated_map_post_audio_meta() {
		$audio_post_format_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'theaisle' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'theaisle' ),
				'description'   => esc_html__( 'Choose audio type', 'theaisle' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'theaisle' ),
					'self'            => esc_html__( 'Self Hosted', 'theaisle' )
				)
			)
		);
		
		$eltdf_audio_embedded_container = theaisle_elated_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'eltdf_audio_embedded_container'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'theaisle' ),
				'description' => esc_html__( 'Enter audio URL', 'theaisle' ),
				'parent'      => $eltdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'theaisle' ),
				'description' => esc_html__( 'Enter audio link', 'theaisle' ),
				'parent'      => $eltdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_post_audio_meta', 23 );
}