<?php

if ( ! function_exists( 'theaisle_elated_map_post_video_meta' ) ) {
	function theaisle_elated_map_post_video_meta() {
		$video_post_format_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'theaisle' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'theaisle' ),
				'description'   => esc_html__( 'Choose video type', 'theaisle' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'theaisle' ),
					'self'            => esc_html__( 'Self Hosted', 'theaisle' )
				)
			)
		);
		
		$eltdf_video_embedded_container = theaisle_elated_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'eltdf_video_embedded_container'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'theaisle' ),
				'description' => esc_html__( 'Enter Video URL', 'theaisle' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'theaisle' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'theaisle' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'theaisle' ),
				'description' => esc_html__( 'Enter video image', 'theaisle' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_post_video_meta', 22 );
}