<?php

/*** Post Settings ***/

if ( ! function_exists( 'theaisle_elated_map_post_meta' ) ) {
	function theaisle_elated_map_post_meta() {
		
		$post_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'theaisle' ),
				'name'  => 'post-meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'theaisle' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'theaisle' ),
				'parent'        => $post_meta_box,
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'theaisle' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'theaisle' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => theaisle_elated_get_custom_sidebars_options( true )
			)
		);
		
		$theaisle_custom_sidebars = theaisle_elated_get_custom_sidebars();
		if ( count( $theaisle_custom_sidebars ) > 0 ) {
			theaisle_elated_create_meta_box_field( array(
				'name'        => 'eltdf_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'theaisle' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'theaisle' ),
				'parent'      => $post_meta_box,
				'options'     => theaisle_elated_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'theaisle' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'theaisle' ),
				'parent'      => $post_meta_box
			)
		);

		do_action('theaisle_elated_action_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_post_meta', 20 );
}
