<?php

if ( ! function_exists( 'theaisle_elated_include_blog_shortcodes' ) ) {
	function theaisle_elated_include_blog_shortcodes() {
		foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/*/load.php' ) as $shortcode_load ) {
			include_once $shortcode_load;
		}
	}
	
	if ( theaisle_elated_core_plugin_installed() ) {
		add_action( 'theaisle_core_action_include_shortcodes_file', 'theaisle_elated_include_blog_shortcodes' );
	}
}

// Load woo elementor widgets
if ( ! function_exists( 'theaisle_elated_include_blog_elementor_widgets_files' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function theaisle_elated_include_blog_elementor_widgets_files() {
		if ( theaisle_elated_is_elementor_installed() ) {
			foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}
	
	if( defined( 'ELEMENTOR_VERSION' ) ) {
		if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
			add_action( 'elementor/widgets/register', 'theaisle_elated_include_blog_elementor_widgets_files' );
		} else {
			add_action( 'elementor/widgets/widgets_registered', 'theaisle_elated_include_blog_elementor_widgets_files' );
		}
	}
}