<?php

if ( ! function_exists( 'theaisle_elated_get_blog_holder_params' ) ) {
	/**
	 * Function that generates params for holders on blog templates
	 */
	function theaisle_elated_get_blog_holder_params( $params ) {
		$params_list = array();
		
		$params_list['holder'] = 'eltdf-container';
		$params_list['inner']  = 'eltdf-container-inner clearfix';
		
		return $params_list;
	}
	
	add_filter( 'theaisle_elated_filter_blog_holder_params', 'theaisle_elated_get_blog_holder_params' );
}

if ( ! function_exists( 'theaisle_elated_blog_part_params' ) ) {
	function theaisle_elated_blog_part_params( $params ) {
		
		$part_params              = array();
		$part_params['title_tag'] = 'h2';
		$part_params['link_tag']  = 'span';
		$part_params['quote_tag'] = 'span';
		
		return array_merge( $params, $part_params );
	}
	
	add_filter( 'theaisle_elated_filter_blog_part_params', 'theaisle_elated_blog_part_params' );
}

if ( ! function_exists( 'theaisle_elated_get_blog_standard_list_classes' ) ) {
    /**
     * Function that generates blog list holder classes for blog list templates
     */
    function theaisle_elated_get_blog_standard_list_classes( $classes ) {
        $list_classes   = array();

        $standard_layout = theaisle_elated_get_meta_field_intersect( 'blog_standard_layout' );
        $list_classes[] = 'eltdf-blog-standard-' . $standard_layout;

        $classes = array_merge( $classes, $list_classes );

        return $classes;
    }

    add_filter( 'theaisle_elated_filter_blog_list_classes', 'theaisle_elated_get_blog_standard_list_classes' );
}