<?php

if ( ! function_exists( 'theaisle_elated_map_content_side_meta' ) ) {
	function theaisle_elated_map_content_side_meta() {
		
		$content_side_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'theaisle_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'content_side_meta' ),
				'title' => esc_html__( 'Content Side Areas', 'theaisle' ),
				'name'  => 'content_side_meta'
			)
		);

        theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_enable_content_side_left_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Content Side Left Area', 'theaisle' ),
				'description'   => esc_html__( 'This option will enable Content Side Left area on pages', 'theaisle' ),
				'parent'        => $content_side_meta_box,
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		$show_content_side_left_meta_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $content_side_meta_box,
				'name'            => 'eltdf_show_content_side_left_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_enable_content_side_left_area_meta' => 'yes'
					)
				)
			)
		);

        theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_content_side_left_sidebar_custom_display_meta',
				'type'          => 'selectblank',
				'default_value' => '',
				'label'         => esc_html__( 'Sidebar to Display', 'theaisle' ),
				'description'   => esc_html__( 'Choose a content side left sidebar to display', 'theaisle' ),
				'options'       => theaisle_elated_get_custom_sidebars(),
				'parent'        => $show_content_side_left_meta_container,
				'args'          => array(
					'select2' => true
				)
			)
		);

        theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_enable_content_side_right_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Content Side Right Area', 'theaisle' ),
				'description'   => esc_html__( 'This option will enable Content Side Right area on pages', 'theaisle' ),
				'parent'        => $content_side_meta_box,
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);

		$show_content_side_right_meta_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $content_side_meta_box,
				'name'            => 'eltdf_show_content_side_right_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_enable_content_side_right_area_meta' => 'yes'
					)
				)
			)
		);

        theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_content_side_right_sidebar_custom_display_meta',
				'type'          => 'selectblank',
				'default_value' => '',
				'label'         => esc_html__( 'Sidebar to Display', 'theaisle' ),
				'description'   => esc_html__( 'Choose a content side right sidebar to display', 'theaisle' ),
				'options'       => theaisle_elated_get_custom_sidebars(),
				'parent'        => $show_content_side_right_meta_container,
				'args'          => array(
					'select2' => true
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_content_side_meta', 72 );
}