<?php

if ( ! function_exists( 'theaisle_elated_content_side_options_map' ) ) {
	function theaisle_elated_content_side_options_map() {
		
		$panel_content_side = theaisle_elated_add_admin_panel(
			array(
				'page'  => '_page_page',
				'name'  => 'panel_content_side',
				'title' => esc_html__( 'Content Side Areas Style', 'theaisle' )
			)
		);

        theaisle_elated_add_admin_field(
			array(
				'name'          => 'enable_content_side_left_area',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Content Side Left Area', 'theaisle' ),
				'description'   => esc_html__( 'This option will enable Content Side Left area on pages', 'theaisle' ),
				'parent'        => $panel_content_side
			)
		);
		
		$enable_content_side_left_area_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $panel_content_side,
				'name'            => 'enable_content_side_left_area_container',
				'dependency' => array(
					'show' => array(
						'enable_content_side_left_area'  => 'yes'
					)
				)
			)
		);
		
		$theaisle_custom_sidebars = theaisle_elated_get_custom_sidebars();

        theaisle_elated_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_side_left_sidebar_custom_display',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Area to Display', 'theaisle' ),
				'description'   => esc_html__( 'Choose a Content Side Left widget area to display', 'theaisle' ),
				'options'       => $theaisle_custom_sidebars,
				'parent'        => $enable_content_side_left_area_container
			)
		);

        theaisle_elated_add_admin_field(
			array(
				'name'          => 'enable_content_side_right_area',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Content Side Right Area', 'theaisle' ),
				'description'   => esc_html__( 'This option will enable Content Side Right area on pages', 'theaisle' ),
				'parent'        => $panel_content_side
			)
		);

		$enable_content_side_right_area_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $panel_content_side,
				'name'            => 'enable_content_side_right_area_container',
				'dependency' => array(
					'show' => array(
						'enable_content_side_right_area'  => 'yes'
					)
				)
			)
		);

        theaisle_elated_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_side_right_sidebar_custom_display',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Area to Display', 'theaisle' ),
				'description'   => esc_html__( 'Choose a Content Side Right widget area to display', 'theaisle' ),
				'options'       => $theaisle_custom_sidebars,
				'parent'        => $enable_content_side_right_area_container
			)
		);
	}
	
	add_action( 'theaisle_elated_action_additional_page_options_map', 'theaisle_elated_content_side_options_map' );
}