<?php

if ( ! function_exists( 'theaisle_elated_get_content_side_areas' ) ) {
	/**
	 * Loads content side areas HTML with all needed parameters
	 */
	function theaisle_elated_get_content_side_areas() {
		$parameters = array();
		
		//Current page id
		$id = theaisle_elated_get_page_id();
		
		//is content bottom area enabled for current page?
		$parameters['content_side_left_area'] = theaisle_elated_get_meta_field_intersect( 'enable_content_side_left_area', $id );
		$parameters['content_side_right_area'] = theaisle_elated_get_meta_field_intersect( 'enable_content_side_right_area', $id );
        $parameters['content_side_right_area_sidebar'] = '';
        $parameters['content_side_left_area_sidebar'] = '';

		if ( $parameters['content_side_left_area'] === 'yes' ) {
			
			//Sidebar for content bottom area
			$parameters['content_side_left_area_sidebar'] = theaisle_elated_get_meta_field_intersect( 'content_side_left_sidebar_custom_display', $id );
		}

		if ( $parameters['content_side_right_area'] === 'yes' ) {

			//Sidebar for content bottom area
			$parameters['content_side_right_area_sidebar'] = theaisle_elated_get_meta_field_intersect( 'content_side_right_sidebar_custom_display', $id );
		}

		if ( ( isset($parameters['content_side_left_area_sidebar'] ) && is_active_sidebar( $parameters['content_side_left_area_sidebar'] ) ) || ( isset($parameters['content_side_right_area_sidebar'] ) && is_active_sidebar( $parameters['content_side_right_area_sidebar'] ) ) ) {
            theaisle_elated_get_module_template_part( 'templates/content-side-area', 'content-side', '', $parameters );
		}
	}
	
	add_action( 'theaisle_elated_action_before_footer_content', 'theaisle_elated_get_content_side_areas' );
}