<?php

if ( ! function_exists( 'theaisle_elated_footer_options_map' ) ) {
	function theaisle_elated_footer_options_map() {

		theaisle_elated_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'theaisle' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = theaisle_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'theaisle' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		theaisle_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'theaisle' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'theaisle' ),
				'parent'        => $footer_panel
			)
		);

        theaisle_elated_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'theaisle' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'theaisle' ),
                'parent'        => $footer_panel
            )
        );

		theaisle_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'theaisle' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'theaisle' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = theaisle_elated_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		theaisle_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'theaisle' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'theaisle' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		theaisle_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'theaisle' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'theaisle' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'theaisle' ),
					'left'   => esc_html__( 'Left', 'theaisle' ),
					'center' => esc_html__( 'Center', 'theaisle' ),
					'right'  => esc_html__( 'Right', 'theaisle' )
				),
				'parent'        => $show_footer_top_container
			)
		);
		
		$footer_top_styles_group = theaisle_elated_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'theaisle' ),
				'description' => esc_html__( 'Define style for footer top area', 'theaisle' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = theaisle_elated_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			theaisle_elated_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'theaisle' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			theaisle_elated_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'theaisle' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			theaisle_elated_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'theaisle' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		theaisle_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'theaisle' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'theaisle' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = theaisle_elated_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		theaisle_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'theaisle' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'theaisle' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = theaisle_elated_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'theaisle' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'theaisle' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = theaisle_elated_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			theaisle_elated_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'theaisle' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			theaisle_elated_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'theaisle' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			theaisle_elated_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'theaisle' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'theaisle_elated_action_options_map', 'theaisle_elated_footer_options_map', theaisle_elated_set_options_map_position( 'footer' ) );
}