<?php

if ( ! function_exists( 'theaisle_elated_get_hide_dep_for_header_menu_area_meta_boxes' ) ) {
	function theaisle_elated_get_hide_dep_for_header_menu_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'theaisle_elated_filter_header_menu_area_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'theaisle_elated_header_menu_area_meta_options_map' ) ) {
	function theaisle_elated_header_menu_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = theaisle_elated_get_hide_dep_for_header_menu_area_meta_boxes();
		
		$menu_area_container = theaisle_elated_add_admin_container_no_style(
			array(
				'type'       => 'container',
				'name'       => 'menu_area_container',
				'parent'     => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta' => $hide_dep_options
					)
				),
				'args'       => array(
					'enable_panels_for_default_value' => true
				)
			)
		);
		
		theaisle_elated_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'theaisle' )
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area In Grid', 'theaisle' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'theaisle' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_container = theaisle_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_in_grid_meta'  => 'yes'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_grid_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'theaisle' ),
				'description' => esc_html__( 'Set grid background color for menu area', 'theaisle' ),
				'parent'      => $menu_area_in_grid_container
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_grid_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'theaisle' ),
				'description' => esc_html__( 'Set grid background transparency for menu area (0 = fully transparent, 1 = opaque)', 'theaisle' ),
				'parent'      => $menu_area_in_grid_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Shadow', 'theaisle' ),
				'description'   => esc_html__( 'Set shadow on grid menu area', 'theaisle' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Border', 'theaisle' ),
				'description'   => esc_html__( 'Set border on grid menu area', 'theaisle' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_border_container = theaisle_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_border_container',
				'parent'          => $menu_area_in_grid_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_in_grid_border_meta'  => 'yes'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_in_grid_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'theaisle' ),
				'description' => esc_html__( 'Set border color for grid area', 'theaisle' ),
				'parent'      => $menu_area_in_grid_border_container
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'theaisle' ),
				'description' => esc_html__( 'Choose a background color for menu area', 'theaisle' ),
				'parent'      => $menu_area_container
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Transparency', 'theaisle' ),
				'description' => esc_html__( 'Choose a transparency for the menu area background color (0 = fully transparent, 1 = opaque)', 'theaisle' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Shadow', 'theaisle' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'theaisle' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Border', 'theaisle' ),
				'description'   => esc_html__( 'Set border on menu area', 'theaisle' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_border_bottom_color_container = theaisle_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_border_bottom_color_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_border_meta'  => 'yes'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'theaisle' ),
				'description' => esc_html__( 'Choose color of header bottom border', 'theaisle' ),
				'parent'      => $menu_area_border_bottom_color_container
			)
		);

		theaisle_elated_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'eltdf_menu_area_height_meta',
				'label'       => esc_html__( 'Height', 'theaisle' ),
				'description' => esc_html__( 'Enter header height', 'theaisle' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px', 'theaisle' )
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'eltdf_menu_area_side_padding_meta',
				'label'       => esc_html__( 'Menu Area Side Padding', 'theaisle' ),
				'description' => esc_html__( 'Enter value in px or percentage to define menu area side padding', 'theaisle' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px or %', 'theaisle' )
				)
			)
		);
		
		do_action( 'theaisle_elated_header_menu_area_additional_meta_boxes_map', $menu_area_container );
	}
	
	add_action( 'theaisle_elated_action_header_menu_area_meta_boxes_map', 'theaisle_elated_header_menu_area_meta_options_map', 10, 1 );
}