<?php

if ( ! function_exists( 'theaisle_elated_get_hide_dep_for_header_centered_options' ) ) {
	function theaisle_elated_get_hide_dep_for_header_centered_options() {
		$hide_dep_options = apply_filters( 'theaisle_elated_filter_header_centered_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'theaisle_elated_header_centered_map' ) ) {
	function theaisle_elated_header_centered_map( $parent ) {
		$hide_dep_options = theaisle_elated_get_hide_dep_for_header_centered_options();
		
		theaisle_elated_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'text',
				'name'            => 'logo_wrapper_padding_header_centered',
				'default_value'   => '',
				'label'           => esc_html__( 'Logo Padding', 'theaisle' ),
				'description'     => esc_html__( 'Insert padding in format: 0px 0px 1px 0px', 'theaisle' ),
				'args'            => array(
					'col_width' => 3
				),
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_header_logo_area_additional_options', 'theaisle_elated_header_centered_map' );
}