<?php

if ( ! function_exists( 'theaisle_elated_register_header_minimal_type' ) ) {
	/**
	 * This function is used to register header type class for header factory file
	 */
	function theaisle_elated_register_header_minimal_type( $header_types ) {
		$header_type = array(
			'header-minimal' => 'TheAisleElatedNamespace\Modules\Header\Types\HeaderMinimal'
		);
		
		$header_types = array_merge( $header_types, $header_type );
		
		return $header_types;
	}
}

if ( ! function_exists( 'theaisle_elated_init_register_header_minimal_type' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function theaisle_elated_init_register_header_minimal_type() {
		add_filter( 'theaisle_elated_filter_register_header_type_class', 'theaisle_elated_register_header_minimal_type' );
	}
	
	add_action( 'theaisle_elated_action_before_header_function_init', 'theaisle_elated_init_register_header_minimal_type' );
}

if ( ! function_exists( 'theaisle_elated_include_header_minimal_full_screen_menu' ) ) {
	/**
	 * Registers additional menu navigation for theme
	 */
	function theaisle_elated_include_header_minimal_full_screen_menu( $menus ) {
		$menus['popup-navigation'] = esc_html__( 'Full Screen Navigation', 'theaisle' );
		
		return $menus;
	}
	
	if ( theaisle_elated_check_is_header_type_enabled( 'header-minimal' ) ) {
		add_filter( 'theaisle_elated_filter_register_headers_menu', 'theaisle_elated_include_header_minimal_full_screen_menu' );
	}
}

if ( ! function_exists( 'theaisle_elated_get_fullscreen_menu_icon_class' ) ) {
	/**
	 * Loads full screen menu icon class
	 */
	function theaisle_elated_get_fullscreen_menu_icon_class() {
		$classes = array(
			'eltdf-fullscreen-menu-opener'
		);
		
		$classes[] = theaisle_elated_get_icon_sources_class( 'fullscreen_menu', 'eltdf-fullscreen-menu-opener' );
		
		return $classes;
	}
}