<?php

if ( ! function_exists( 'theaisle_elated_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function theaisle_elated_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'theaisle_elated_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'theaisle_elated_header_standard_meta_map' ) ) {
	function theaisle_elated_header_standard_meta_map( $parent ) {
		$hide_dep_options = theaisle_elated_get_hide_dep_for_header_standard_meta_boxes();
		
		theaisle_elated_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'eltdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'theaisle' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'theaisle' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'theaisle' ),
					'left'   => esc_html__( 'Left', 'theaisle' ),
					'right'  => esc_html__( 'Right', 'theaisle' ),
					'center' => esc_html__( 'Center', 'theaisle' )
				),
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_additional_header_area_meta_boxes_map', 'theaisle_elated_header_standard_meta_map' );
}