<?php

if ( ! function_exists( 'theaisle_elated_map_sidebar_meta' ) ) {
	function theaisle_elated_map_sidebar_meta() {
		$eltdf_sidebar_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'theaisle_elated_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'theaisle' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'theaisle' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'theaisle' ),
				'parent'      => $eltdf_sidebar_meta_box,
                'options'       => theaisle_elated_get_custom_sidebars_options( true )
			)
		);
		
		$eltdf_custom_sidebars = theaisle_elated_get_custom_sidebars();
		if ( count( $eltdf_custom_sidebars ) > 0 ) {
			theaisle_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'theaisle' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'theaisle' ),
					'parent'      => $eltdf_sidebar_meta_box,
					'options'     => $eltdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_sidebar_meta', 31 );
}