<?php

if ( ! function_exists( 'theaisle_elated_sidebar_options_map' ) ) {
	function theaisle_elated_sidebar_options_map() {
		
		theaisle_elated_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'theaisle' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = theaisle_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'theaisle' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		theaisle_elated_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'theaisle' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'theaisle' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => theaisle_elated_get_custom_sidebars_options()
		) );
		
		$theaisle_custom_sidebars = theaisle_elated_get_custom_sidebars();
		if ( count( $theaisle_custom_sidebars ) > 0 ) {
			theaisle_elated_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'theaisle' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'theaisle' ),
				'parent'      => $sidebar_panel,
				'options'     => $theaisle_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'theaisle_elated_action_options_map', 'theaisle_elated_sidebar_options_map', theaisle_elated_set_options_map_position( 'sidebar' ) );
}