<?php

if ( ! function_exists( 'theaisle_elated_skewed_section_title_meta' ) ) {
	function theaisle_elated_skewed_section_title_meta( $show_title_area_container ) {
		
		theaisle_elated_add_admin_section_title(
			array(
				'parent' => $show_title_area_container,
				'name'   => 'skewed_section_container',
				'title'  => esc_html__( 'Skewed Section', 'theaisle' )
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_enable_skewed_section_on_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Skewed Section', 'theaisle' ),
				'description'   => esc_html__( 'This option will enable/disable Skew Section on Title Area', 'theaisle' ),
				'options'       => theaisle_elated_get_yes_no_select_array(),
				'parent'        => $show_title_area_container
			)
		);
		
		$show_skewed_section_title_area_container = theaisle_elated_add_admin_container(
			array(
				'parent'     => $show_title_area_container,
				'name'       => 'show_skewed_section_title_area_container',
				'dependency' => array(
					'show' => array(
						'eltdf_enable_skewed_section_on_title_area_meta' => 'yes'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_title_area_skewed_section_type_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Position', 'theaisle' ),
				'description'   => esc_html__( 'Specify skewed section position', 'theaisle' ),
				'parent'        => $show_skewed_section_title_area_container,
				'options'       => array(
					''        => esc_html__( 'Default', 'theaisle' ),
					'outline' => esc_html__( 'Outline', 'theaisle' ),
					'inset'   => esc_html__( 'Inset', 'theaisle' )
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_title_area_container,
				'type'        => 'textarea',
				'name'        => 'eltdf_title_area_skewed_section_svg_path_meta',
				'label'       => esc_html__( 'Skewed Section On Title Area SVG Path', 'theaisle' ),
				'description' => esc_html__( 'Enter your Section On Title Area SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'theaisle' ),
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_title_area_container,
				'type'        => 'color',
				'name'        => 'eltdf_title_area_skewed_section_svg_color_meta',
				'label'       => esc_html__( 'Skewed Section Color', 'theaisle' ),
				'description' => esc_html__( 'Choose a background color for Skewed Section', 'theaisle' ),
			)
		);
	}
	
	add_action( 'theaisle_elated_action_additional_title_area_meta_boxes', 'theaisle_elated_skewed_section_title_meta', 20 );
}

if ( ! function_exists( 'theaisle_elated_skewed_section_header_meta' ) ) {
	function theaisle_elated_skewed_section_header_meta( $show_header_area_container ) {
		
		theaisle_elated_add_admin_section_title(
			array(
				'parent' => $show_header_area_container,
				'name'   => 'skewed_section_container',
				'title'  => esc_html__( 'Skewed Section', 'theaisle' )
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_enable_skewed_section_on_header_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Skewed Section', 'theaisle' ),
				'description'   => esc_html__( 'This option will enable/disable Skew Section on Header Area', 'theaisle' ),
				'options'       => theaisle_elated_get_yes_no_select_array(),
				'parent'        => $show_header_area_container
			)
		);
		
		$show_skewed_section_header_area_container = theaisle_elated_add_admin_container(
			array(
				'parent'     => $show_header_area_container,
				'name'       => 'show_skewed_section_header_area_container',
				'dependency' => array(
					'show' => array(
						'eltdf_enable_skewed_section_on_header_area_meta' => 'yes'
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_header_area_container,
				'type'        => 'textarea',
				'name'        => 'eltdf_header_area_skewed_section_svg_path_meta',
				'label'       => esc_html__( 'Skewed Section On Header Area SVG Path', 'theaisle' ),
				'description' => esc_html__( 'Enter your Section On Header Area SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'theaisle' ),
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_header_area_container,
				'type'        => 'color',
				'name'        => 'eltdf_header_area_skewed_section_svg_color_meta',
				'label'       => esc_html__( 'Skewed Section Color', 'theaisle' ),
				'description' => esc_html__( 'Choose a background color for Skewed Section', 'theaisle' ),
			)
		);
	}
	
	add_action( 'theaisle_elated_action_additional_header_area_meta_boxes', 'theaisle_elated_skewed_section_header_meta', 20 );
}