<?php

if ( ! function_exists( 'theaisle_elated_get_title_types_meta_boxes' ) ) {
	function theaisle_elated_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'theaisle_elated_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'theaisle' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'theaisle_elated_map_title_meta' ) ) {
	function theaisle_elated_map_title_meta() {
		$title_type_meta_boxes = theaisle_elated_get_title_types_meta_boxes();
		
		$title_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'theaisle_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'theaisle' ),
				'name'  => 'title_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'theaisle' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'theaisle' ),
				'parent'        => $title_meta_box,
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = theaisle_elated_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'eltdf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'eltdf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'theaisle' ),
						'description'   => esc_html__( 'Choose title type', 'theaisle' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'theaisle' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'theaisle' ),
						'options'       => theaisle_elated_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				theaisle_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'theaisle' ),
						'description' => esc_html__( 'Set a height for Title Area', 'theaisle' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				theaisle_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'theaisle' ),
						'description' => esc_html__( 'Choose a background color for title area', 'theaisle' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				theaisle_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'theaisle' ),
						'description' => esc_html__( 'Choose an Image for title area', 'theaisle' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'theaisle' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'theaisle' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'theaisle' ),
							'hide'                => esc_html__( 'Hide Image', 'theaisle' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'theaisle' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'theaisle' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'theaisle' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'theaisle' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'theaisle' )
						)
					)
				);
				
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'theaisle' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'theaisle' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'theaisle' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'theaisle' ),
							'window-top'    => esc_html__( 'From Window Top', 'theaisle' )
						)
					)
				);
				
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'theaisle' ),
						'options'       => theaisle_elated_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				theaisle_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'theaisle' ),
						'description' => esc_html__( 'Choose a color for title text', 'theaisle' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'theaisle' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'theaisle' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				theaisle_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'theaisle' ),
						'options'       => theaisle_elated_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				theaisle_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'theaisle' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'theaisle' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'theaisle_elated_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_title_meta', 60 );
}