<?php

if ( class_exists( 'TheAisleCoreClassWidget' ) ) {
    class TheAisleElatedClassButtonWidget extends TheAisleCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'eltdf_button_widget',
                esc_html__( 'TheAisle Button Widget', 'theaisle' ),
                array( 'description' => esc_html__( 'Add button element to widget areas', 'theaisle' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $this->params = array(
                array(
                    'type'    => 'dropdown',
                    'name'    => 'type',
                    'title'   => esc_html__( 'Type', 'theaisle' ),
                    'options' => array(
                        'solid'   => esc_html__( 'Solid', 'theaisle' ),
                        'outline' => esc_html__( 'Outline', 'theaisle' ),
                        'simple'  => esc_html__( 'Simple', 'theaisle' )
                    )
                ),
                array(
                    'type'        => 'dropdown',
                    'name'        => 'size',
                    'title'       => esc_html__( 'Size', 'theaisle' ),
                    'options'     => array(
                        'small'  => esc_html__( 'Small', 'theaisle' ),
                        'medium' => esc_html__( 'Medium', 'theaisle' ),
                        'large'  => esc_html__( 'Large', 'theaisle' ),
                        'huge'   => esc_html__( 'Huge', 'theaisle' )
                    ),
                    'description' => esc_html__( 'This option is only available for solid and outline button type', 'theaisle' )
                ),
                array(
                    'type'    => 'textfield',
                    'name'    => 'text',
                    'title'   => esc_html__( 'Text', 'theaisle' ),
                    'default' => esc_html__( 'Button Text', 'theaisle' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'link',
                    'title' => esc_html__( 'Link', 'theaisle' )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'target',
                    'title'   => esc_html__( 'Link Target', 'theaisle' ),
                    'options' => theaisle_elated_get_link_target_array()
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'color',
                    'title' => esc_html__( 'Color', 'theaisle' )
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'hover_color',
                    'title' => esc_html__( 'Hover Color', 'theaisle' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'background_color',
                    'title'       => esc_html__( 'Background Color', 'theaisle' ),
                    'description' => esc_html__( 'This option is only available for solid button type', 'theaisle' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'hover_background_color',
                    'title'       => esc_html__( 'Hover Background Color', 'theaisle' ),
                    'description' => esc_html__( 'This option is only available for solid button type', 'theaisle' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'border_color',
                    'title'       => esc_html__( 'Border Color', 'theaisle' ),
                    'description' => esc_html__( 'This option is only available for solid and outline button type', 'theaisle' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'hover_border_color',
                    'title'       => esc_html__( 'Hover Border Color', 'theaisle' ),
                    'description' => esc_html__( 'This option is only available for solid and outline button type', 'theaisle' )
                ),
                array(
                    'type'        => 'textfield',
                    'name'        => 'margin',
                    'title'       => esc_html__( 'Margin', 'theaisle' ),
                    'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'theaisle' )
                )
            );
        }

        public function widget( $args, $instance ) {
            $params = '';

            if ( ! is_array( $instance ) ) {
                $instance = array();
            }

            // Filter out all empty params
            $instance = array_filter( $instance, function ( $array_value ) {
                return trim( $array_value ) != '';
            } );

            // Default values
            if ( ! isset( $instance['text'] ) ) {
                $instance['text'] = 'Button Text';
            }

            // Generate shortcode params
            foreach ( $instance as $key => $value ) {
                $params .= " $key='$value' ";
            }

            echo '<div class="widget eltdf-button-widget">';
            echo do_shortcode( "[eltdf_button $params]" ); // XSS OK
            echo '</div>';
        }
    }
}