<?php

if ( class_exists( 'TheAisleCoreClassWidget' ) ) {
    class TheAisleElatedClassSeparatorWidget extends TheAisleCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'eltdf_separator_widget',
                esc_html__( 'TheAisle Separator Widget', 'theaisle' ),
                array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'theaisle' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $this->params = array(
                array(
                    'type'    => 'dropdown',
                    'name'    => 'type',
                    'title'   => esc_html__( 'Type', 'theaisle' ),
                    'options' => array(
                        'normal'     => esc_html__( 'Normal', 'theaisle' ),
                        'full-width' => esc_html__( 'Full Width', 'theaisle' )
                    )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'position',
                    'title'   => esc_html__( 'Position', 'theaisle' ),
                    'options' => array(
                        'center' => esc_html__( 'Center', 'theaisle' ),
                        'left'   => esc_html__( 'Left', 'theaisle' ),
                        'right'  => esc_html__( 'Right', 'theaisle' )
                    )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'border_style',
                    'title'   => esc_html__( 'Style', 'theaisle' ),
                    'options' => array(
                        'solid'  => esc_html__( 'Solid', 'theaisle' ),
                        'dashed' => esc_html__( 'Dashed', 'theaisle' ),
                        'dotted' => esc_html__( 'Dotted', 'theaisle' )
                    )
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'color',
                    'title' => esc_html__( 'Color', 'theaisle' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'width',
                    'title' => esc_html__( 'Width (px or %)', 'theaisle' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'thickness',
                    'title' => esc_html__( 'Thickness (px)', 'theaisle' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'top_margin',
                    'title' => esc_html__( 'Top Margin (px or %)', 'theaisle' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'bottom_margin',
                    'title' => esc_html__( 'Bottom Margin (px or %)', 'theaisle' )
                )
            );
        }

        public function widget( $args, $instance ) {
            if ( ! is_array( $instance ) ) {
                $instance = array();
            }

            //prepare variables
            $params = '';

            //is instance empty?
            if ( is_array( $instance ) && count( $instance ) ) {
                //generate shortcode params
                foreach ( $instance as $key => $value ) {
                    $params .= " $key='$value' ";
                }
            }

            echo '<div class="widget eltdf-separator-widget">';
            echo do_shortcode( "[eltdf_separator $params]" ); // XSS OK
            echo '</div>';
        }
    }
}