<?php

if ( ! function_exists( 'theaisle_elated_map_woocommerce_meta' ) ) {
	function theaisle_elated_map_woocommerce_meta() {
		
		$woocommerce_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'theaisle' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'theaisle' ),
				'description' => esc_html__( 'Choose image layout when it appears in Elated Product List - Masonry layout shortcode', 'theaisle' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'theaisle' ),
					'small'              => esc_html__( 'Small', 'theaisle' ),
					'large-width'        => esc_html__( 'Large Width', 'theaisle' ),
					'large-height'       => esc_html__( 'Large Height', 'theaisle' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'theaisle' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'theaisle' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'theaisle' ),
				'options'       => theaisle_elated_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'theaisle' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'theaisle' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_elated_map_woocommerce_meta', 99 );
}