<?php
class TheAisleElatedElementorProductList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_product_list'; 
	}

	public function get_title() {
		return esc_html__( 'Product List', 'theaisle' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-product-list';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'theaisle'),
					'masonry' => esc_html__( 'Masonry', 'theaisle')
				),
				'default' => 'standard'
			]
		);

		$this->add_control(
			'info_position',
			[
				'label'     => esc_html__( 'Product Info Position', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'info-on-image' => esc_html__( 'Info On Image Hover', 'theaisle'),
					'info-below-image' => esc_html__( 'Info Below Image', 'theaisle')
				),
				'default' => 'info-below-image'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Products', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle'),
					'one' => esc_html__( 'One', 'theaisle'),
					'two' => esc_html__( 'Two', 'theaisle'),
					'three' => esc_html__( 'Three', 'theaisle'),
					'four' => esc_html__( 'Four', 'theaisle'),
					'five' => esc_html__( 'Five', 'theaisle'),
					'six' => esc_html__( 'Six', 'theaisle')
				),
				'default' => 'four'
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'huge' => esc_html__( 'Huge (40)', 'theaisle'),
					'large' => esc_html__( 'Large (25)', 'theaisle'),
					'medium' => esc_html__( 'Medium (20)', 'theaisle'),
					'normal' => esc_html__( 'Normal (15)', 'theaisle'),
					'small' => esc_html__( 'Small (10)', 'theaisle'),
					'tiny' => esc_html__( 'Tiny (5)', 'theaisle'),
					'no' => esc_html__( 'No (0)', 'theaisle')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'theaisle'),
					'ID' => esc_html__( 'ID', 'theaisle'),
					'menu_order' => esc_html__( 'Menu Order', 'theaisle'),
					'name' => esc_html__( 'Post Name', 'theaisle'),
					'rand' => esc_html__( 'Random', 'theaisle'),
					'title' => esc_html__( 'Title', 'theaisle'),
					'on-sale' => esc_html__( 'On Sale', 'theaisle')
				),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'theaisle'),
					'DESC' => esc_html__( 'DESC', 'theaisle')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'taxonomy_to_display',
			[
				'label'     => esc_html__( 'Choose Sorting Taxonomy', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'If you would like to display only certain products, this is where you can select the criteria by which you would like to choose which products to display', 'theaisle' ),
				'options' => array(
					'category' => esc_html__( 'Category', 'theaisle'),
					'tag' => esc_html__( 'Tag', 'theaisle'),
					'id' => esc_html__( 'Id', 'theaisle')
				),
				'default' => 'category'
			]
		);

		$this->add_control(
			'taxonomy_values',
			[
				'label'     => esc_html__( 'Enter Taxonomy Values', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Separate values (category slugs, tags, or post IDs) with a comma', 'theaisle' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Proportions', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle'),
					'full' => esc_html__( 'Original', 'theaisle'),
					'square' => esc_html__( 'Square', 'theaisle'),
					'landscape' => esc_html__( 'Landscape', 'theaisle'),
					'portrait' => esc_html__( 'Portrait', 'theaisle'),
					'medium' => esc_html__( 'Medium', 'theaisle'),
					'large' => esc_html__( 'Large', 'theaisle'),
					'woocommerce_single' => esc_html__( 'Shop Single', 'theaisle'),
					'woocommerce_thumbnail' => esc_html__( 'Shop Thumbnail', 'theaisle')
				),
				'default' => 'full'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'product_info',
			[
				'label' => esc_html__( 'Product Info', 'theaisle' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'display_title',
			[
				'label'     => esc_html__( 'Display Title', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle'),
					'no' => esc_html__( 'No', 'theaisle')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'display_category',
			[
				'label'     => esc_html__( 'Display Category', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'theaisle'),
					'yes' => esc_html__( 'Yes', 'theaisle')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'display_excerpt',
			[
				'label'     => esc_html__( 'Display Excerpt', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'theaisle'),
					'yes' => esc_html__( 'Yes', 'theaisle')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'display_rating',
			[
				'label'     => esc_html__( 'Display Rating', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle'),
					'no' => esc_html__( 'No', 'theaisle')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'display_price',
			[
				'label'     => esc_html__( 'Display Price', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle'),
					'no' => esc_html__( 'No', 'theaisle')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'display_button',
			[
				'label'     => esc_html__( 'Display Button', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle'),
					'no' => esc_html__( 'No', 'theaisle')
				),
				'default' => 'yes'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'product_info_style',
			[
				'label' => esc_html__( 'Product Info Style', 'theaisle' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'product_info_skin',
			[
				'label'     => esc_html__( 'Product Info Skin', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'theaisle'),
					'light' => esc_html__( 'Light', 'theaisle'),
					'dark' => esc_html__( 'Dark', 'theaisle')
				),
				'default' => 'default',
				'condition' => [
					'info_position' => array( 'info-on-image' )
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle'),
					'h1' => esc_html__( 'h1', 'theaisle'),
					'h2' => esc_html__( 'h2', 'theaisle'),
					'h3' => esc_html__( 'h3', 'theaisle'),
					'h4' => esc_html__( 'h4', 'theaisle'),
					'h5' => esc_html__( 'h5', 'theaisle'),
					'h6' => esc_html__( 'h6', 'theaisle')
				),
				'default' => 'h5',
				'condition' => [
					'display_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle'),
					'none' => esc_html__( 'None', 'theaisle'),
					'capitalize' => esc_html__( 'Capitalize', 'theaisle'),
					'uppercase' => esc_html__( 'Uppercase', 'theaisle'),
					'lowercase' => esc_html__( 'Lowercase', 'theaisle'),
					'initial' => esc_html__( 'Initial', 'theaisle'),
					'inherit' => esc_html__( 'Inherit', 'theaisle')
				),
				'default' => '',
				'condition' => [
					'display_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label'     => esc_html__( 'Excerpt Length', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of characters', 'theaisle' ),
				'condition' => [
					'display_excerpt' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_skin',
			[
				'label'     => esc_html__( 'Button Skin', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'theaisle'),
					'light' => esc_html__( 'Light', 'theaisle'),
					'dark' => esc_html__( 'Dark', 'theaisle')
				),
				'default' => 'default',
				'condition' => [
					'display_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'shader_background_color',
			[
				'label'     => esc_html__( 'Shader Background Color', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'info_bottom_text_align',
			[
				'label'     => esc_html__( 'Product Info Text Alignment', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle'),
					'left' => esc_html__( 'Left', 'theaisle'),
					'center' => esc_html__( 'Center', 'theaisle'),
					'right' => esc_html__( 'Right', 'theaisle')
				),
				'default' => '',
				'condition' => [
					'info_position' => array( 'info-below-image' )
				]
			]
		);

		$this->add_control(
			'info_bottom_margin',
			[
				'label'     => esc_html__( 'Product Info Bottom Margin (px)', 'theaisle' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'info_position' => array( 'info-below-image' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


		
		$params['class_name']     = 'pli';
		$params['type']           = ! empty( $params['type'] ) ? $params['type'] : 'standard';
		$params['info_position']  = ! empty( $params['info_position'] ) ? $params['info_position'] : 'info-below-image';
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h5';
		
		$additional_params                   = array();
		$additional_params['holder_classes'] = $this->getHolderClasses( $params );
		
		$queryArray                        = $this->generateProductQueryArray( $params );
		$query_result                      = new \WP_Query( $queryArray );
		$additional_params['query_result'] = $query_result;
		
		$params['this_object'] = $this;
		
		echo theaisle_elated_get_woo_shortcode_module_template_part( 'templates/product-list', 'product-list', $params['type'], $params, $additional_params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses   = array();
		$holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-' . $params['type'] . '-layout' : '';
		$holderClasses[] = ! empty( $params['number_of_columns'] ) ? 'eltdf-' . $params['number_of_columns'] . '-columns' : '';
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'eltdf-' . $params['space_between_items'] . '-space' : '';
		$holderClasses[] = ! empty( $params['info_position'] ) ? 'eltdf-' . $params['info_position'] : '';
		$holderClasses[] = ! empty( $params['product_info_skin'] ) ? 'eltdf-product-info-' . $params['product_info_skin'] : '';
		
		return implode( ' ', $holderClasses );
	}

	private function generateProductQueryArray( $params ) {
		$queryArray = array(
			'post_status'         => 'publish',
			'post_type'           => 'product',
			'ignore_sticky_posts' => 1,
			'posts_per_page'      => $params['number_of_posts'],
			'orderby'             => $params['orderby'],
			'order'               => $params['order']
		);
		
		if ( $params['orderby'] === 'on-sale' ) {
			$queryArray['no_found_rows'] = 1;
			$queryArray['post__in']      = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'category' ) {
			$queryArray['product_cat'] = $params['taxonomy_values'];
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'tag' ) {
			$queryArray['product_tag'] = $params['taxonomy_values'];
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'id' ) {
			$idArray                = $params['taxonomy_values'];
			$ids                    = explode( ',', $idArray );
            $queryArray['orderby'] = 'post__in';
			$queryArray['post__in'] = $ids;
		}
		
		return $queryArray;
	}

	public function getItemClasses( $params ) {
		$itemClasses = array();
		
		$image_size_meta = get_post_meta( get_the_ID(), 'eltdf_product_featured_image_size', true );
		
		if ( ! empty( $image_size_meta ) ) {
			$itemClasses[] = 'eltdf-fixed-masonry-item eltdf-masonry-size-' . $image_size_meta;
		}
		
		return implode( ' ', $itemClasses );
	}

	public function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['title_transform'];
		}
		
		return implode( ';', $styles );
	}

	public function getShaderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['shader_background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['shader_background_color'];
		}
		
		return implode( ';', $styles );
	}

	public function getTextWrapperStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['info_bottom_text_align'] ) ) {
			$styles[] = 'text-align: ' . $params['info_bottom_text_align'];
		}
		
		if ( $params['info_bottom_margin'] !== '' ) {
			$styles[] = 'margin-bottom: ' . theaisle_elated_filter_px( $params['info_bottom_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleElatedElementorProductList() );