<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 *
 * @var bool   $readonly If the input should be set to readonly mode.
 * @var string $type     The input type attribute.
 */

defined( 'ABSPATH' ) || exit;

if ( ! isset ( $input_id ) ) {
	$input_id = uniqid( 'quantity_' );
}

/* translators: %s: Quantity. */
$label = esc_html__( 'Quantity', 'theaisle' );

$holder_classes = array(
	'eltdf-quantity-buttons',
	'quantity',
);

if ( $max_value && $min_value === $max_value ) {
	$hidden           = true;
	$holder_classes[] = 'hidden';
} else {
	$hidden = false;
} ?>

<div class="<?php echo implode( ' ', $holder_classes ); ?>">
	<?php do_action( 'woocommerce_before_quantity_input_field' ); ?>
	<label class="screen-reader-text" for="<?php echo esc_attr( $input_id ); ?>"><?php echo esc_attr( $label ); ?></label>

	<?php if ( $hidden ) { ?>
		<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>" />
	<?php } else { ?>
		<?php $labelledby = ! empty( $args['product_name'] ) ? sprintf( esc_html__( '%s quantity', 'theaisle' ), strip_tags( $args['product_name'] ) ) : ''; ?>
		<span class="eltdf-quantity-minus icon_minus-06"></span>
		<input type="text" id="<?php echo esc_attr( $input_id ); ?>" class="input-text qty text eltdf-quantity-input" data-step="<?php echo esc_attr( $step ); ?>" data-min="<?php echo esc_attr( $min_value ); ?>" data-max="<?php echo esc_attr( 0 < $max_value ? $max_value : '' ); ?>" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $input_value ); ?>" aria-label="<?php esc_attr_e( 'Qty', 'theaisle' ); ?>" size="4" pattern="<?php echo esc_attr( $pattern ); ?>" inputmode="<?php echo esc_attr( $inputmode ); ?>" aria-labelledby="<?php echo esc_attr( $labelledby ); ?>" />
		<span class="eltdf-quantity-plus icon_plus"></span>
	<?php } ?>
	<?php do_action( 'woocommerce_after_quantity_input_field' ); ?>
</div>
