<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<form role="search" method="get" class="eltdf-searchform woocommerce-product-search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label class="screen-reader-text"><?php esc_html_e( 'Search for:', 'theaisle' ); ?></label>
	<div class="input-holder clearfix">
		<input type="search" class="search-field" placeholder="<?php esc_attr_e('Search Products...', 'theaisle'); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php esc_attr_e('Search for:', 'theaisle'); ?>"/>
		<button type="submit" class="eltdf-search-submit <?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ); ?>">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                 width="19.156px" height="18.313px" viewBox="0 0 19.156 18.313" enable-background="new 0 0 19.156 18.313" xml:space="preserve">
            <g>
                <path d="M8.144,16.196c-4.43,0-8.034-3.604-8.034-8.034c0-4.43,3.604-8.034,8.034-8.034
                    c4.43,0,8.034,3.604,8.034,8.034C16.177,12.593,12.574,16.196,8.144,16.196z M8.144,1.173c-3.854,0-6.99,3.135-6.99,6.989
                    s3.135,6.989,6.99,6.989c3.854,0,6.989-3.135,6.989-6.989S11.998,1.173,8.144,1.173z"/>
            </g>
                            <g>
                                <path d="M18.554,18.246c-0.122,0-0.244-0.043-0.344-0.13l-4.679-4.099c-0.217-0.19-0.239-0.52-0.049-0.737
                    c0.19-0.217,0.52-0.238,0.737-0.049l4.68,4.1c0.216,0.189,0.238,0.52,0.048,0.736C18.843,18.186,18.699,18.246,18.554,18.246z"/>
                            </g>
            </svg>
        </button>
		<input type="hidden" name="post_type" value="product"/>
	</div>
</form>