<?php
/*
Plugin Name: TheAisle Twitter Feed
Plugin URI: https://qodeinteractive.com
Description: Plugin that adds Twitter feed functionality to our theme
Author: Elated Themes
Author URI: https://qodeinteractive.com
Version: 2.0.2
*/
define( 'THEAISLE_TWITTER_FEED_VERSION', '2.0.2' );
define( 'THEAISLE_TWITTER_ABS_PATH', dirname( __FILE__ ) );
define( 'THEAISLE_TWITTER_REL_PATH', dirname( plugin_basename( __FILE__ ) ) );
define( 'THEAISLE_TWITTER_URL_PATH', plugin_dir_url( __FILE__ ) );
define( 'THEAISLE_TWITTER_ASSETS_PATH', THEAISLE_TWITTER_ABS_PATH . '/assets' );
define( 'THEAISLE_TWITTER_ASSETS_URL_PATH', THEAISLE_TWITTER_URL_PATH . 'assets' );
define( 'THEAISLE_TWITTER_SHORTCODES_PATH', THEAISLE_TWITTER_ABS_PATH . '/shortcodes' );
define( 'THEAISLE_TWITTER_SHORTCODES_URL_PATH', THEAISLE_TWITTER_URL_PATH . 'shortcodes' );

include_once 'load.php';

if ( ! function_exists( 'theaisle_twitter_theme_installed' ) ) {
	/**
	 * Checks whether theme is installed or not
	 * @return bool
	 */
	function theaisle_twitter_theme_installed() {
		return defined( 'ELATED_ROOT' );
	}
}

if ( ! function_exists( 'theaisle_twitter_feed_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function theaisle_twitter_feed_text_domain() {
		load_plugin_textdomain( 'theaisle-twitter-feed', false, THEAISLE_TWITTER_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'theaisle_twitter_feed_text_domain' );
}