<?php

if ( ! function_exists( 'theaisle_core_map_portfolio_meta' ) ) {
	function theaisle_core_map_portfolio_meta() {
		global $theaisle_elated_global_Framework;
		
		$theaisle_pages = array();
		$pages      = get_pages();
		foreach ( $pages as $page ) {
			$theaisle_pages[ $page->ID ] = $page->post_title;
		}
		
		//Portfolio Images
		
		$theaisle_portfolio_images = new TheAisleElatedClassMetaBox( 'portfolio-item', esc_html__( 'Portfolio Images (multiple upload)', 'theaisle-core' ), '', '', 'portfolio_images' );
		$theaisle_elated_global_Framework->eltdMetaBoxes->addMetaBox( 'portfolio_images', $theaisle_portfolio_images );
		
		$theaisle_portfolio_image_gallery = new TheAisleElatedClassMultipleImages( 'eltdf-portfolio-image-gallery', esc_html__( 'Portfolio Images', 'theaisle-core' ), esc_html__( 'Choose your portfolio images', 'theaisle-core' ) );
		$theaisle_portfolio_images->addChild( 'eltdf-portfolio-image-gallery', $theaisle_portfolio_image_gallery );
		
		//Portfolio Single Upload Images/Videos 
		
		$theaisle_portfolio_images_videos = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Portfolio Images/Videos (single upload)', 'theaisle-core' ),
				'name'  => 'eltdf_portfolio_images_videos'
			)
		);
		theaisle_elated_add_repeater_field(
			array(
				'name'        => 'eltdf_portfolio_single_upload',
				'parent'      => $theaisle_portfolio_images_videos,
				'button_text' => esc_html__( 'Add Image/Video', 'theaisle-core' ),
				'fields'      => array(
					array(
						'type'        => 'select',
						'name'        => 'file_type',
						'label'       => esc_html__( 'File Type', 'theaisle-core' ),
						'options' => array(
							'image' => esc_html__('Image','theaisle-core'),
							'video' => esc_html__('Video','theaisle-core'),
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'single_image',
						'label'       => esc_html__( 'Image', 'theaisle-core' ),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'image'
							)
						)
					),
					array(
						'type'        => 'select',
						'name'        => 'video_type',
						'label'       => esc_html__( 'Video Type', 'theaisle-core' ),
						'options'	  => array(
							'youtube' => esc_html__('YouTube', 'theaisle-core'),
							'vimeo' => esc_html__('Vimeo', 'theaisle-core'),
							'self' => esc_html__('Self Hosted', 'theaisle-core'),
						),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'video'
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_id',
						'label'       => esc_html__( 'Video ID', 'theaisle-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => array('youtube','vimeo')
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_mp4',
						'label'       => esc_html__( 'Video mp4', 'theaisle-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'video_cover_image',
						'label'       => esc_html__( 'Video Cover Image', 'theaisle-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					)
				)
			)
		);
		
		//Portfolio Additional Sidebar Items
		
		$theaisle_additional_sidebar_items = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Additional Portfolio Sidebar Items', 'theaisle-core' ),
				'name'  => 'portfolio_properties'
			)
		);

		theaisle_elated_add_repeater_field(
			array(
				'name'        => 'eltdf_portfolio_properties',
				'parent'      => $theaisle_additional_sidebar_items,
				'button_text' => esc_html__( 'Add New Item', 'theaisle-core' ),
				'fields'      => array(
					array(
						'type'        => 'text',
						'name'        => 'item_title',
						'label'       => esc_html__( 'Item Title', 'theaisle-core' ),
					),
					array(
						'type'        => 'text',
						'name'        => 'item_text',
						'label'       => esc_html__( 'Item Text', 'theaisle-core' )
					),
					array(
						'type'        => 'text',
						'name'        => 'item_url',
						'label'       => esc_html__( 'Enter Full URL for Item Text Link', 'theaisle-core' )
					)
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_core_map_portfolio_meta', 40 );
}