<?php

if ( ! function_exists( 'theaisle_core_map_portfolio_settings_meta' ) ) {
	function theaisle_core_map_portfolio_settings_meta() {
		$meta_box = theaisle_elated_create_meta_box( array(
			'scope' => 'portfolio-item',
			'title' => esc_html__( 'Portfolio Settings', 'theaisle-core' ),
			'name'  => 'portfolio_settings_meta_box'
		) );
		
		theaisle_elated_create_meta_box_field( array(
			'name'        => 'eltdf_portfolio_single_template_meta',
			'type'        => 'select',
			'label'       => esc_html__( 'Portfolio Type', 'theaisle-core' ),
			'description' => esc_html__( 'Choose a default type for Single Project pages', 'theaisle-core' ),
			'parent'      => $meta_box,
			'options'     => array(
				''                  => esc_html__( 'Default', 'theaisle-core' ),
				'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'theaisle-core' ),
				'images'            => esc_html__( 'Portfolio Images', 'theaisle-core' ),
				'small-images'      => esc_html__( 'Portfolio Small Images', 'theaisle-core' ),
				'slider'            => esc_html__( 'Portfolio Slider', 'theaisle-core' ),
				'small-slider'      => esc_html__( 'Portfolio Small Slider', 'theaisle-core' ),
				'gallery'           => esc_html__( 'Portfolio Gallery', 'theaisle-core' ),
				'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'theaisle-core' ),
				'masonry'           => esc_html__( 'Portfolio Masonry', 'theaisle-core' ),
				'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'theaisle-core' ),
				'custom'            => esc_html__( 'Portfolio Custom', 'theaisle-core' ),
				'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'theaisle-core' ),
				'simple-text'       => esc_html__( 'Portfolio Simple Text', 'theaisle-core' )
			)
		) );

		/***************** Simple Layout *****************/

		$simple_text_type_meta_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'eltdf_simple_text_type_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_portfolio_single_template_meta'  => array(
							'simple-text'
						)
					)
				)
			)
		);

		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_simple_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Simple Text Title', 'theaisle-core' ),
				'description' => esc_html__( 'Enter the tile for Simple Text Portfolio List page', 'theaisle-core' ),
				'parent'      => $simple_text_type_meta_container,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$gallery_type_meta_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'eltdf_gallery_type_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_portfolio_single_template_meta'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_gallery_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'theaisle-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'theaisle-core' ),
				'parent'        => $gallery_type_meta_container,
				'options'       => theaisle_elated_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_gallery_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'theaisle-core' ),
				'default_value' => '',
				'options'       => theaisle_elated_get_space_between_items_array( true ),
				'parent'        => $gallery_type_meta_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$masonry_type_meta_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'eltdf_masonry_type_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_portfolio_single_template_meta'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_masonry_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'theaisle-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'theaisle-core' ),
				'parent'        => $masonry_type_meta_container,
				'options'       => theaisle_elated_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_masonry_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'theaisle-core' ),
				'default_value' => '',
				'options'       => theaisle_elated_get_space_between_items_array( true ),
				'parent'        => $masonry_type_meta_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_portfolio_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single portfolio page', 'theaisle-core' ),
				'parent'        => $meta_box,
				'options'       => theaisle_elated_get_yes_no_select_array()
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_info_top_padding',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Info Top Padding', 'theaisle-core' ),
				'description' => esc_html__( 'Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'theaisle-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_external_link',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio External Link', 'theaisle-core' ),
				'description' => esc_html__( 'Enter URL to link from Portfolio List page', 'theaisle-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_portfolio_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Featured Image', 'theaisle-core' ),
				'description' => esc_html__( 'Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'theaisle-core' ),
				'parent'      => $meta_box
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_masonry_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'theaisle-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is fixed', 'theaisle-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''                   => esc_html__( 'Default', 'theaisle-core' ),
					'small'              => esc_html__( 'Small', 'theaisle-core' ),
					'large-width'        => esc_html__( 'Large Width', 'theaisle-core' ),
					'large-height'       => esc_html__( 'Large Height', 'theaisle-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'theaisle-core' )
				)
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_masonry_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Original Proportion', 'theaisle-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is original', 'theaisle-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''            => esc_html__( 'Default', 'theaisle-core' ),
					'large-width' => esc_html__( 'Large Width', 'theaisle-core' )
				)
			)
		);
		
		$all_pages = array();
		$pages     = get_pages();
		foreach ( $pages as $page ) {
			$all_pages[ $page->ID ] = $page->post_title;
		}
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_single_back_to_link',
				'type'        => 'select',
				'label'       => esc_html__( '"Back To" Link', 'theaisle-core' ),
				'description' => esc_html__( 'Choose "Back To" page to link from portfolio Single Project page', 'theaisle-core' ),
				'parent'      => $meta_box,
				'options'     => $all_pages,
				'args'        => array(
					'select2' => true
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_core_map_portfolio_settings_meta', 41 );
}