<?php

if ( ! function_exists( 'theaisle_elated_portfolio_options_map' ) ) {
	function theaisle_elated_portfolio_options_map() {
		
		theaisle_elated_add_admin_page(
			array(
				'slug'  => '_portfolio',
				'title' => esc_html__( 'Portfolio', 'theaisle-core' ),
				'icon'  => 'fa fa-camera-retro'
			)
		);
		
		$panel_archive = theaisle_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Archive', 'theaisle-core' ),
				'name'  => 'panel_portfolio_archive',
				'page'  => '_portfolio'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'        => 'portfolio_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'theaisle-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list on archive pages. Default value is 12', 'theaisle-core' ),
				'parent'      => $panel_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'theaisle-core' ),
				'default_value' => 'four',
				'description'   => esc_html__( 'Set number of columns for your portfolio list on archive pages. Default value is Four columns', 'theaisle-core' ),
				'parent'        => $panel_archive,
				'options'       => theaisle_elated_get_number_of_columns_array( false, array( 'one', 'six' ) )
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'description'   => esc_html__( 'Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'theaisle-core' ),
				'default_value' => 'normal',
				'options'       => theaisle_elated_get_space_between_items_array(),
				'parent'        => $panel_archive
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_image_size',
				'type'          => 'select',
				'label'         => esc_html__( 'Image Proportions', 'theaisle-core' ),
				'default_value' => 'landscape',
				'description'   => esc_html__( 'Set image proportions for your portfolio list on archive pages. Default value is landscape', 'theaisle-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'full'      => esc_html__( 'Original', 'theaisle-core' ),
					'landscape' => esc_html__( 'Landscape', 'theaisle-core' ),
					'portrait'  => esc_html__( 'Portrait', 'theaisle-core' ),
					'square'    => esc_html__( 'Square', 'theaisle-core' )
				)
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_item_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Item Style', 'theaisle-core' ),
				'default_value' => 'standard-shader',
				'description'   => esc_html__( 'Set item style for your portfolio list on archive pages. Default value is Standard - Shader', 'theaisle-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'standard-shader' => esc_html__( 'Standard - Shader', 'theaisle-core' ),
					'gallery-overlay' => esc_html__( 'Gallery - Overlay', 'theaisle-core' )
				)
			)
		);
		
		$panel = theaisle_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Single', 'theaisle-core' ),
				'name'  => 'panel_portfolio_single',
				'page'  => '_portfolio'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_template',
				'type'          => 'select',
				'label'         => esc_html__( 'Portfolio Type', 'theaisle-core' ),
				'default_value' => 'small-images',
				'description'   => esc_html__( 'Choose a default type for Single Project pages', 'theaisle-core' ),
				'parent'        => $panel,
				'options'       => array(
					'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'theaisle-core' ),
					'images'            => esc_html__( 'Portfolio Images', 'theaisle-core' ),
					'small-images'      => esc_html__( 'Portfolio Small Images', 'theaisle-core' ),
					'slider'            => esc_html__( 'Portfolio Slider', 'theaisle-core' ),
					'small-slider'      => esc_html__( 'Portfolio Small Slider', 'theaisle-core' ),
					'gallery'           => esc_html__( 'Portfolio Gallery', 'theaisle-core' ),
					'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'theaisle-core' ),
					'masonry'           => esc_html__( 'Portfolio Masonry', 'theaisle-core' ),
					'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'theaisle-core' ),
					'custom'            => esc_html__( 'Portfolio Custom', 'theaisle-core' ),
					'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'theaisle-core' ),
					'simple-text'       => esc_html__( 'Portfolio Simple Text', 'theaisle-core' )
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$portfolio_gallery_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_gallery_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'theaisle-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'theaisle-core' ),
				'parent'        => $portfolio_gallery_container,
				'options'       => theaisle_elated_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'theaisle-core' ),
				'default_value' => 'normal',
				'options'       => theaisle_elated_get_space_between_items_array(),
				'parent'        => $portfolio_gallery_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$portfolio_masonry_container = theaisle_elated_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_masonry_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'theaisle-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'theaisle-core' ),
				'parent'        => $portfolio_masonry_container,
				'options'       => theaisle_elated_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'theaisle-core' ),
				'default_value' => 'normal',
				'options'       => theaisle_elated_get_space_between_items_array(),
				'parent'        => $portfolio_masonry_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		theaisle_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_portfolio_single',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single projects', 'theaisle-core' ),
				'parent'        => $panel,
				'options'       => array(
					''    => esc_html__( 'Default', 'theaisle-core' ),
					'yes' => esc_html__( 'Yes', 'theaisle-core' ),
					'no'  => esc_html__( 'No', 'theaisle-core' )
				),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_images',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Images', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for projects with images', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_videos',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Videos', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_enable_categories',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Categories', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will enable category meta description on single projects', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_date',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Date', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will enable date meta on single projects', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_sticky_sidebar',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Sticky Side Text', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will show comments on your page', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_pagination',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Hide Pagination', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will turn off portfolio pagination functionality', 'theaisle-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		$container_navigate_category = theaisle_elated_add_admin_container(
			array(
				'name'            => 'navigate_same_category_container',
				'parent'          => $panel,
				'dependency' => array(
					'hide' => array(
						'portfolio_single_hide_pagination'  => array(
							'yes'
						)
					)
				)
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_nav_same_category',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Pagination Through Same Category', 'theaisle-core' ),
				'description'   => esc_html__( 'Enabling this option will make portfolio pagination sort through current category', 'theaisle-core' ),
				'parent'        => $container_navigate_category,
				'default_value' => 'no'
			)
		);
		
		theaisle_elated_add_admin_field(
			array(
				'name'        => 'portfolio_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Single Slug', 'theaisle-core' ),
				'description' => esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'theaisle-core' ),
				'parent'      => $panel,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'theaisle_elated_action_options_map', 'theaisle_elated_portfolio_options_map', theaisle_elated_set_options_map_position( 'portfolio' ) );
}