<?php

if ( ! function_exists( 'theaisle_core_map_testimonials_meta' ) ) {
	function theaisle_core_map_testimonials_meta() {
		$testimonial_meta_box = theaisle_elated_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'theaisle-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'theaisle-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'theaisle-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'theaisle-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'theaisle-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'theaisle-core' ),
				'description' => esc_html__( 'Enter author name', 'theaisle-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		theaisle_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'theaisle-core' ),
				'description' => esc_html__( 'Enter author job position', 'theaisle-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'theaisle_elated_action_meta_boxes_map', 'theaisle_core_map_testimonials_meta', 95 );
}