<?php
class TheAisleElatedElementorTestimonials extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_testimonials'; 
	}

	public function get_title() {
		return esc_html__( 'Testimonials', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-testimonials';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'theaisle-core'), 
					'boxed' => esc_html__( 'Boxed', 'theaisle-core')
				),
				'default' => 'standard'
			]
		);

		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Skin', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'light' => esc_html__( 'Light', 'theaisle-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'quote_mark_color',
			[
				'label'     => esc_html__( 'Quote Mark Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'standard' )
				]
			]
		);

		$this->add_control(
			'text_side_padding',
			[
				'label'     => esc_html__( 'Text Side Padding', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'type' => array( 'standard' )
				]
			]
		);

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number of Testimonials', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'theaisle-core' )
			]
		);

		$this->add_control(
			'box_color',
			[
				'label'     => esc_html__( 'Content Box Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'boxed' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_settings',
			[
				'label' => esc_html__( 'Slider Settings', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_visible_items',
			[
				'label'     => esc_html__( 'Number Of Visible Items', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'theaisle-core'), 
					'2' => esc_html__( 'Two', 'theaisle-core'), 
					'3' => esc_html__( 'Three', 'theaisle-core'), 
					'4' => esc_html__( 'Four', 'theaisle-core'), 
					'5' => esc_html__( 'Five', 'theaisle-core'), 
					'6' => esc_html__( 'Six', 'theaisle-core')
				),
				'default' => '3',
				'condition' => [
					'type' => array( 'boxed' )
				]
			]
		);

		$this->add_control(
			'slider_loop',
			[
				'label'     => esc_html__( 'Enable Slider Loop', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label'     => esc_html__( 'Enable Slider Autoplay', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_speed',
			[
				'label'     => esc_html__( 'Slide Duration', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default value is 5000 (ms)', 'theaisle-core' )
			]
		);

		$this->add_control(
			'slider_speed_animation',
			[
				'label'     => esc_html__( 'Slide Animation Duration', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 600.', 'theaisle-core' )
			]
		);

		$this->add_control(
			'slider_navigation',
			[
				'label'     => esc_html__( 'Enable Slider Navigation Arrows', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'boxed', 'standard' )
				]
			]
		);

		$this->add_control(
			'enable_navigation_numbers',
			[
				'label'     => esc_html__( 'Enable Slider Navigation Arrow Numbers', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes',
				'condition' => [
					'slider_navigation' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'slider_pagination',
			[
				'label'     => esc_html__( 'Enable Slider Pagination', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'boxed', 'standard' )
				]
			]
		);

		$this->add_control(
			'nav_skin',
			[
				'label'     => esc_html__( 'Navigation and Pagination Skin', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'light' => esc_html__( 'Light', 'theaisle-core')
				),
				'default' => ''
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


		
		$params['type'] = ! empty( $params['type'] ) ? $params['type'] : 'standard';
		
		$params['holder_classes'] = $this->getHolderClasses( $params );

		$params['query_args']    = $this->getQueryParams( $params );
		$params['query_results'] = new \WP_Query( $params['query_args'] );
		
		$params['box_styles'] = $this->getBoxStyles( $params );
		$params['quote_styles'] = $this->getQuoteStyles( $params );
		$params['text_styles'] = $this->getTextStyles( $params );
		$params['data_attr'] = $this->getSliderData( $params );

        echo theaisle_core_get_cpt_shortcode_module_template_part( 'testimonials', 'testimonials', 'testimonials-' . $params['type'], '', $params );

	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = 'eltdf-testimonials-' . $params['type'];
		$holderClasses[] = ! empty( $params['skin'] ) ? 'eltdf-testimonials-' . $params['skin'] : '';
		$holderClasses[] = ! empty( $params['nav_skin'] ) ? 'eltdf-testimonials-skin-' . $params['nav_skin'] : '';
        $holderClasses[] = $params['enable_navigation_numbers'] === 'yes' ? 'eltdf-navigation-numbers' : '';

		return implode( ' ', $holderClasses );
	}

	private function getQueryParams( $params ) {
		$args = array(
			'post_status'    => 'publish',
			'post_type'      => 'testimonials',
			'orderby'        => 'date',
			'order'          => 'DESC',
			'posts_per_page' => $params['number']
		);
		
		if ( $params['category'] != '' ) {
			$args['testimonials-category'] = $params['category'];
		}
		
		return $args;
	}

    public function getQuoteStyles( $params ) {
        $styles = array();

        if ( $params['type'] === 'standard' && ! empty( $params['quote_mark_color'] ) ) {
            $styles[] = 'color: ' . $params['quote_mark_color'];
        }

        return $styles;
    }

    public function getTextStyles( $params ) {
	    $styles = array();

	    if($params['type'] === 'standard' && $params['text_side_padding'] !== '') {
	        $styles[] = 'padding: 0 '.$params['text_side_padding'];
        }

        return $styles;
    }

	public function getBoxStyles( $params ) {
		$styles = array();
		
		if ( $params['type'] === 'boxed' && ! empty( $params['box_color'] ) ) {
			$styles[] = 'background-color: ' . $params['box_color'];
		}
		
		return $styles;
	}

	private function getSliderData( $params ) {
		$slider_data = array();
		
		$slider_data['data-number-of-items']        = ! empty( $params['number_of_visible_items'] ) && in_array($params['type'], array('boxed')) ? $params['number_of_visible_items'] : '1';
		$slider_data['data-enable-loop']            = ! empty( $params['slider_loop'] ) ? $params['slider_loop'] : '';
		$slider_data['data-enable-autoplay']        = ! empty( $params['slider_autoplay'] ) ? $params['slider_autoplay'] : '';
		$slider_data['data-slider-speed']           = ! empty( $params['slider_speed'] ) ? $params['slider_speed'] : '5000';
		$slider_data['data-slider-speed-animation'] = ! empty( $params['slider_speed_animation'] ) ? $params['slider_speed_animation'] : '600';
		$slider_data['data-enable-navigation']      = ! empty( $params['slider_navigation'] ) ? $params['slider_navigation'] : '';
		$slider_data['data-enable-pagination']      = ! empty( $params['slider_pagination'] ) ? $params['slider_pagination'] : '';
		$slider_data['data-slider-margin']          = in_array($params['type'], array('boxed')) ? 24 : '';

		return $slider_data;
	}

	public function testimonialsCategoryAutocompleteSuggester( $query ) {
		global $wpdb;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.slug AS slug, a.name AS testimonials_category_title
					FROM {$wpdb->terms} AS a
					LEFT JOIN ( SELECT term_id, taxonomy  FROM {$wpdb->term_taxonomy} ) AS b ON b.term_id = a.term_id
					WHERE b.taxonomy = 'testimonials-category' AND a.name LIKE '%%%s%%'", stripslashes( $query ) ), ARRAY_A );
		
		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data          = array();
				$data['value'] = $value['slug'];
				$data['label'] = ( ( strlen( $value['testimonials_category_title'] ) > 0 ) ? esc_html__( 'Category', 'theaisle-core' ) . ': ' . $value['testimonials_category_title'] : '' );
				$results[]     = $data;
			}
		}
		
		return $results;
		
	}

	public function testimonialsCategoryAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {
			// get portfolio category
			$testimonials_category = get_term_by( 'slug', $query, 'testimonials-category' );
			if ( is_object( $testimonials_category ) ) {
				
				$testimonials_category_slug  = $testimonials_category->slug;
				$testimonials_category_title = $testimonials_category->name;
				
				$testimonials_category_title_display = '';
				if ( ! empty( $testimonials_category_title ) ) {
					$testimonials_category_title_display = esc_html__( 'Category', 'theaisle-core' ) . ': ' . $testimonials_category_title;
				}
				
				$data          = array();
				$data['value'] = $testimonials_category_slug;
				$data['label'] = $testimonials_category_title_display;
				
				return ! empty( $data ) ? $data : false;
			}
			
			return false;
		}
		
		return false;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleElatedElementorTestimonials() );