<?php
class TheAisleCoreElementorCountdown extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_countdown'; 
	}

	public function get_title() {
		return esc_html__( 'Countdown', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-countdown';
	}

	public function get_categories() {
		return [ 'elated' ];
	}
	
	public function get_script_depends() {
		return array(
			'jquery-plugin',
			'countdown'
		);
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
			]
		);

		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Skin', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'eltdf-light-skin' => esc_html__( 'Light', 'theaisle-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'boxes_with_shadow',
			[
				'label'     => esc_html__( 'Display countdown elements in boxes', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);
		
		$currentYear = date("Y");
		$endYear = $currentYear + 5;
		$yearOptions = array();
		for ($year = $currentYear; $year <= $endYear; $year++) {
			$yearOptions[$year] = esc_html__( $year, 'theaisle-core');
		}
		
		$this->add_control(
			'year',
			[
				'label'     => esc_html__( 'Year', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => $yearOptions,
				'default' => '2018'
			]
		);

		$this->add_control(
			'month',
			[
				'label'     => esc_html__( 'Month', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'January', 'theaisle-core'), 
					'2' => esc_html__( 'February', 'theaisle-core'), 
					'3' => esc_html__( 'March', 'theaisle-core'), 
					'4' => esc_html__( 'April', 'theaisle-core'), 
					'5' => esc_html__( 'May', 'theaisle-core'), 
					'6' => esc_html__( 'June', 'theaisle-core'), 
					'7' => esc_html__( 'July', 'theaisle-core'), 
					'8' => esc_html__( 'August', 'theaisle-core'), 
					'9' => esc_html__( 'September', 'theaisle-core'), 
					'10' => esc_html__( 'October', 'theaisle-core'), 
					'11' => esc_html__( 'November', 'theaisle-core'), 
					'12' => esc_html__( 'December', 'theaisle-core')
				),
				'default' => '1'
			]
		);

		$this->add_control(
			'day',
			[
				'label'     => esc_html__( 'Day', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( '1', 'theaisle-core'), 
					'2' => esc_html__( '2', 'theaisle-core'), 
					'3' => esc_html__( '3', 'theaisle-core'), 
					'4' => esc_html__( '4', 'theaisle-core'), 
					'5' => esc_html__( '5', 'theaisle-core'), 
					'6' => esc_html__( '6', 'theaisle-core'), 
					'7' => esc_html__( '7', 'theaisle-core'), 
					'8' => esc_html__( '8', 'theaisle-core'), 
					'9' => esc_html__( '9', 'theaisle-core'), 
					'10' => esc_html__( '10', 'theaisle-core'), 
					'11' => esc_html__( '11', 'theaisle-core'), 
					'12' => esc_html__( '12', 'theaisle-core'), 
					'13' => esc_html__( '13', 'theaisle-core'), 
					'14' => esc_html__( '14', 'theaisle-core'), 
					'15' => esc_html__( '15', 'theaisle-core'), 
					'16' => esc_html__( '16', 'theaisle-core'), 
					'17' => esc_html__( '17', 'theaisle-core'), 
					'18' => esc_html__( '18', 'theaisle-core'), 
					'19' => esc_html__( '19', 'theaisle-core'), 
					'20' => esc_html__( '20', 'theaisle-core'), 
					'21' => esc_html__( '21', 'theaisle-core'), 
					'22' => esc_html__( '22', 'theaisle-core'), 
					'23' => esc_html__( '23', 'theaisle-core'), 
					'24' => esc_html__( '24', 'theaisle-core'), 
					'25' => esc_html__( '25', 'theaisle-core'), 
					'26' => esc_html__( '26', 'theaisle-core'), 
					'27' => esc_html__( '27', 'theaisle-core'), 
					'28' => esc_html__( '28', 'theaisle-core'), 
					'29' => esc_html__( '29', 'theaisle-core'), 
					'30' => esc_html__( '30', 'theaisle-core'), 
					'31' => esc_html__( '31', 'theaisle-core')
				),
				'default' => '1'
			]
		);

		$this->add_control(
			'hour',
			[
				'label'     => esc_html__( 'Hour', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'0' => esc_html__( '0', 'theaisle-core'), 
					'1' => esc_html__( '1', 'theaisle-core'), 
					'2' => esc_html__( '2', 'theaisle-core'), 
					'3' => esc_html__( '3', 'theaisle-core'), 
					'4' => esc_html__( '4', 'theaisle-core'), 
					'5' => esc_html__( '5', 'theaisle-core'), 
					'6' => esc_html__( '6', 'theaisle-core'), 
					'7' => esc_html__( '7', 'theaisle-core'), 
					'8' => esc_html__( '8', 'theaisle-core'), 
					'9' => esc_html__( '9', 'theaisle-core'), 
					'10' => esc_html__( '10', 'theaisle-core'), 
					'11' => esc_html__( '11', 'theaisle-core'), 
					'12' => esc_html__( '12', 'theaisle-core'), 
					'13' => esc_html__( '13', 'theaisle-core'), 
					'14' => esc_html__( '14', 'theaisle-core'), 
					'15' => esc_html__( '15', 'theaisle-core'), 
					'16' => esc_html__( '16', 'theaisle-core'), 
					'17' => esc_html__( '17', 'theaisle-core'), 
					'18' => esc_html__( '18', 'theaisle-core'), 
					'19' => esc_html__( '19', 'theaisle-core'), 
					'20' => esc_html__( '20', 'theaisle-core'), 
					'21' => esc_html__( '21', 'theaisle-core'), 
					'22' => esc_html__( '22', 'theaisle-core'), 
					'23' => esc_html__( '23', 'theaisle-core'), 
					'24' => esc_html__( '24', 'theaisle-core')
				),
				'default' => '0'
			]
		);

		$this->add_control(
			'minute',
			[
				'label'     => esc_html__( 'Minute', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'0' => esc_html__( '0', 'theaisle-core'), 
					'1' => esc_html__( '1', 'theaisle-core'), 
					'2' => esc_html__( '2', 'theaisle-core'), 
					'3' => esc_html__( '3', 'theaisle-core'), 
					'4' => esc_html__( '4', 'theaisle-core'), 
					'5' => esc_html__( '5', 'theaisle-core'), 
					'6' => esc_html__( '6', 'theaisle-core'), 
					'7' => esc_html__( '7', 'theaisle-core'), 
					'8' => esc_html__( '8', 'theaisle-core'), 
					'9' => esc_html__( '9', 'theaisle-core'), 
					'10' => esc_html__( '10', 'theaisle-core'), 
					'11' => esc_html__( '11', 'theaisle-core'), 
					'12' => esc_html__( '12', 'theaisle-core'), 
					'13' => esc_html__( '13', 'theaisle-core'), 
					'14' => esc_html__( '14', 'theaisle-core'), 
					'15' => esc_html__( '15', 'theaisle-core'), 
					'16' => esc_html__( '16', 'theaisle-core'), 
					'17' => esc_html__( '17', 'theaisle-core'), 
					'18' => esc_html__( '18', 'theaisle-core'), 
					'19' => esc_html__( '19', 'theaisle-core'), 
					'20' => esc_html__( '20', 'theaisle-core'), 
					'21' => esc_html__( '21', 'theaisle-core'), 
					'22' => esc_html__( '22', 'theaisle-core'), 
					'23' => esc_html__( '23', 'theaisle-core'), 
					'24' => esc_html__( '24', 'theaisle-core'), 
					'25' => esc_html__( '25', 'theaisle-core'), 
					'26' => esc_html__( '26', 'theaisle-core'), 
					'27' => esc_html__( '27', 'theaisle-core'), 
					'28' => esc_html__( '28', 'theaisle-core'), 
					'29' => esc_html__( '29', 'theaisle-core'), 
					'30' => esc_html__( '30', 'theaisle-core'), 
					'31' => esc_html__( '31', 'theaisle-core'), 
					'32' => esc_html__( '32', 'theaisle-core'), 
					'33' => esc_html__( '33', 'theaisle-core'), 
					'34' => esc_html__( '34', 'theaisle-core'), 
					'35' => esc_html__( '35', 'theaisle-core'), 
					'36' => esc_html__( '36', 'theaisle-core'), 
					'37' => esc_html__( '37', 'theaisle-core'), 
					'38' => esc_html__( '38', 'theaisle-core'), 
					'39' => esc_html__( '39', 'theaisle-core'), 
					'40' => esc_html__( '40', 'theaisle-core'), 
					'41' => esc_html__( '41', 'theaisle-core'), 
					'42' => esc_html__( '42', 'theaisle-core'), 
					'43' => esc_html__( '43', 'theaisle-core'), 
					'44' => esc_html__( '44', 'theaisle-core'), 
					'45' => esc_html__( '45', 'theaisle-core'), 
					'46' => esc_html__( '46', 'theaisle-core'), 
					'47' => esc_html__( '47', 'theaisle-core'), 
					'48' => esc_html__( '48', 'theaisle-core'), 
					'49' => esc_html__( '49', 'theaisle-core'), 
					'50' => esc_html__( '50', 'theaisle-core'), 
					'51' => esc_html__( '51', 'theaisle-core'), 
					'52' => esc_html__( '52', 'theaisle-core'), 
					'53' => esc_html__( '53', 'theaisle-core'), 
					'54' => esc_html__( '54', 'theaisle-core'), 
					'55' => esc_html__( '55', 'theaisle-core'), 
					'56' => esc_html__( '56', 'theaisle-core'), 
					'57' => esc_html__( '57', 'theaisle-core'), 
					'58' => esc_html__( '58', 'theaisle-core'), 
					'59' => esc_html__( '59', 'theaisle-core'), 
					'60' => esc_html__( '60', 'theaisle-core')
				),
				'default' => '0'
			]
		);

		$this->add_control(
			'month_label',
			[
				'label'     => esc_html__( 'Month Label', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'day_label',
			[
				'label'     => esc_html__( 'Day Label', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'hour_label',
			[
				'label'     => esc_html__( 'Hour Label', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'minute_label',
			[
				'label'     => esc_html__( 'Minute Label', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'second_label',
			[
				'label'     => esc_html__( 'Second Label', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'digit_font_size',
			[
				'label'     => esc_html__( 'Digit Font Size (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'label_font_size',
			[
				'label'     => esc_html__( 'Label Font Size (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$params['id']             = mt_rand( 1000, 9999 );
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['holder_data']    = $this->getHolderData( $params );

		echo theaisle_core_get_shortcode_module_template_part( 'templates/countdown', 'countdown', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ($params['boxes_with_shadow'] === 'yes') ? 'eltdf-countdown-with-boxes' : '';
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['skin'] ) ? $params['skin'] : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderData( $params ) {
		$holderData = array();
		
		$holderData['data-year']         = ! empty( $params['year'] ) ? $params['year'] : '';
		$holderData['data-month']        = ! empty( $params['month'] ) ? $params['month'] : '';
		$holderData['data-day']          = ! empty( $params['day'] ) ? $params['day'] : '';
		$holderData['data-hour']         = $params['hour'] !== '' ? $params['hour'] : '';
		$holderData['data-minute']       = $params['minute'] !== '' ? $params['minute'] : '';
		$holderData['data-month-label']  = ! empty( $params['month_label'] ) ? $params['month_label'] : esc_html__( 'Months', 'theaisle-core' );
		$holderData['data-day-label']    = ! empty( $params['day_label'] ) ? $params['day_label'] : esc_html__( 'Days', 'theaisle-core' );
		$holderData['data-hour-label']   = ! empty( $params['hour_label'] ) ? $params['hour_label'] : esc_html__( 'Hours', 'theaisle-core' );
		$holderData['data-minute-label'] = ! empty( $params['minute_label'] ) ? $params['minute_label'] : esc_html__( 'Minutes', 'theaisle-core' );
		$holderData['data-second-label'] = ! empty( $params['second_label'] ) ? $params['second_label'] : esc_html__( 'Seconds', 'theaisle-core' );
		$holderData['data-digit-size']   = ! empty( $params['digit_font_size'] ) ? $params['digit_font_size'] : '';
		$holderData['data-label-size']   = ! empty( $params['label_font_size'] ) ? $params['label_font_size'] : '';
		
		return $holderData;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorCountdown() );