<?php

if ( ! function_exists( 'theaisle_core_add_countdown_shortcodes' ) ) {
	function theaisle_core_add_countdown_shortcodes( $shortcodes_class_name ) {
		$shortcodes = array(
			'TheAisleCore\CPT\Shortcodes\Countdown\Countdown'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'theaisle_core_filter_add_vc_shortcode', 'theaisle_core_add_countdown_shortcodes' );
}

if ( ! function_exists( 'theaisle_core_set_countdown_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for countdown shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function theaisle_core_set_countdown_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-countdown';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'theaisle_core_filter_add_vc_shortcodes_custom_icon_class', 'theaisle_core_set_countdown_icon_class_name_for_vc_shortcodes' );
}

if ( ! function_exists( 'theaisle_core_register_countdown_scripts' ) ) {
	/**
	 * Function that register scripts for countdown shortcode
	 */
	function theaisle_core_register_countdown_scripts( ) {

		wp_register_script( 'jquery-plugin', THEAISLE_CORE_SHORTCODES_URL_PATH . '/countdown/assets/js/plugins/jquery.plugin.js', array( 'jquery' ), false, true );
		wp_register_script( 'countdown', THEAISLE_CORE_SHORTCODES_URL_PATH . '/countdown/assets/js/plugins/jquery.countdown.min.js', array( 'jquery' ), false, true );

	}

	add_action( 'theaisle_elated_action_enqueue_third_party_scripts', 'theaisle_core_register_countdown_scripts' );
}