(function ($) {
	'use strict';
	
	var fullScreenImageSlider = {};
	eltdf.modules.fullScreenImageSlider = fullScreenImageSlider;
	
	
	fullScreenImageSlider.eltdfOnWindowLoad = eltdfOnWindowLoad;
	
	$(window).on('load', eltdfOnWindowLoad);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfInitFullScreenImageSlider();
		eltdfElementorFullScreenImageSlider();
	}
	
	/**
	 * Elementor
	 */
	function eltdfElementorFullScreenImageSlider(){
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/eltdf_full_screen_image_slider.default', function() {
				eltdf.modules.common.eltdfOwlSlider();
				eltdfInitFullScreenImageSlider();
			} );
		});
	}
	
	/**
	 * Init Full Screen Image Slider Shortcode
	 */
	function eltdfInitFullScreenImageSlider() {
		var holder = $('.eltdf-fsis-slider');
		
		if (holder.length) {
			holder.each(function () {
				var sliderHolder = $(this),
					mainHolder = sliderHolder.parent(),
					prevThumbNav = mainHolder.children('.eltdf-fsis-prev-nav'),
					nextThumbNav = mainHolder.children('.eltdf-fsis-next-nav'),
					maskHolder = mainHolder.children('.eltdf-fsis-slider-mask');
				
				mainHolder.addClass('eltdf-fsis-is-init');
				
				eltdfImageBehavior(sliderHolder);
				eltdfPrevNextImageBehavior(sliderHolder, prevThumbNav, nextThumbNav, -1); // -1 is arbitrary value because 0 can be index of item
				
				sliderHolder.on('drag.owl.carousel', function () {
					setTimeout(function () {
						if (!maskHolder.hasClass('eltdf-drag') && !mainHolder.hasClass('eltdf-fsis-active')) {
							maskHolder.addClass('eltdf-drag');
						}
					}, 200);
				});
				
				sliderHolder.on('dragged.owl.carousel', function () {
					setTimeout(function () {
						if (maskHolder.hasClass('eltdf-drag')) {
							maskHolder.removeClass('eltdf-drag');
						}
					}, 300);
				});
				
				sliderHolder.on('translate.owl.carousel', function (e) {
					eltdfPrevNextImageBehavior(sliderHolder, prevThumbNav, nextThumbNav, e.item.index);
				});
				
				sliderHolder.on('translated.owl.carousel', function () {
					eltdfImageBehavior(sliderHolder);
					
					setTimeout(function () {
						maskHolder.removeClass('eltdf-drag');
					}, 300);
				});
			});
		}
	}
	
	function eltdfImageBehavior(sliderHolder) {
		var activeItem = sliderHolder.find('.owl-item.active'),
			imageHolder = sliderHolder.find('.eltdf-fsis-item');
		
		imageHolder.removeClass('eltdf-fsis-content-image-init');
		
		eltdfResetImageBehavior(sliderHolder);
		
		if (activeItem.length) {
			var activeImageHolder = activeItem.find('.eltdf-fsis-item'),
				activeItemImage = activeImageHolder.children('.eltdf-fsis-image');
			
			setTimeout(function () {
				activeImageHolder.addClass('eltdf-fsis-content-image-init');
			}, 100);
			
			activeItemImage.off().on('mouseenter', function () {
				activeImageHolder.addClass('eltdf-fsis-image-hover');
			}).on('mouseleave', function () {
				activeImageHolder.removeClass('eltdf-fsis-image-hover');
			}).on('click', function () {
				if (activeImageHolder.hasClass('eltdf-fsis-active-image')) {
					sliderHolder.trigger('play.owl.autoplay');
					sliderHolder.parent().removeClass('eltdf-fsis-active');
					activeImageHolder.removeClass('eltdf-fsis-active-image');
				} else {
					sliderHolder.trigger('stop.owl.autoplay');
					sliderHolder.parent().addClass('eltdf-fsis-active');
					activeImageHolder.addClass('eltdf-fsis-active-image');
				}
			});
			
			//Close on escape
			$(document).keyup(function (e) {
				if (e.keyCode === 27) { //KeyCode for ESC button is 27
					sliderHolder.trigger('play.owl.autoplay');
					sliderHolder.parent().removeClass('eltdf-fsis-active');
					activeImageHolder.removeClass('eltdf-fsis-active-image');
				}
			});
		}
	}
	
	function eltdfPrevNextImageBehavior(sliderHolder, prevThumbNav, nextThumbNav, itemIndex) {
		var activeItem = itemIndex === -1 ? sliderHolder.find('.owl-item.active') : $(sliderHolder.find('.owl-item')[itemIndex]),
			prevItemImage = activeItem.prev().find('.eltdf-fsis-image').css('background-image'),
			nextItemImage = activeItem.next().find('.eltdf-fsis-image').css('background-image');
		
		if (prevItemImage.length) {
			prevThumbNav.css({'background-image': prevItemImage});
		}
		
		if (nextItemImage.length) {
			nextThumbNav.css({'background-image': nextItemImage});
		}
	}
	
	function eltdfResetImageBehavior(sliderHolder) {
		var imageHolder = sliderHolder.find('.eltdf-fsis-item');
		
		if (imageHolder.length) {
			imageHolder.removeClass('eltdf-fsis-active-image');
		}
	}
	
})(jQuery);