(function($) {
    'use strict';

    var iconWithText = {};
    eltdf.modules.iconWithText = iconWithText;

    iconWithText.eltdfInitIconWithText = eltdfInitIconWithText;


    iconWithText.eltdfOnDocumentReady = eltdfOnDocumentReady;

    $(document).ready(eltdfOnDocumentReady);
	$(window).on('load', eltdfOnWindowLoad);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function eltdfOnDocumentReady() {
        eltdfInitIconWithText()
    }
	
	/**
	 All functions to be called on $(window).load() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfElementorIconWithText();
	}
	
	/**
	 * Elementor
	 */
	function eltdfElementorIconWithText(){
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/eltdf_icon_with_text.default', function() {
				eltdfInitIconWithText().init();
			} );
		});
	}

    /**
     * Inti icon with text shortcode on appear
     */
    function eltdfInitIconWithText() {
        var holder = $('.eltdf-iwt.eltdf-iwt-icon-top');

        if(holder.length) {
            holder.each(function(){
                var thisHolder = $(this);

                thisHolder.appear(function(){
                    thisHolder.addClass('eltdf-iwt-icon-top-appeared');
                },{accX: 0, accY: eltdfGlobalVars.vars.eltdfElementAppearAmount});
            });
        }
    }

})(jQuery);