<?php
class TheAisleCoreElementorImageCarouselWithText extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_image_carousel_with_text'; 
	}

	public function get_title() {
		return esc_html__( 'Image Carousel With Text', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-image-carousel-with-text';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
			]
		);

		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'text-left' => esc_html__( 'Text on Left Side', 'theaisle-core'), 
					'text-right' => esc_html__( 'Text on Right Side', 'theaisle-core')
				),
				'default' => 'text-left'
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'     => esc_html__( 'Subtitle', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$this->add_control(
			'images',
			[
				'label'     => esc_html__( 'Images', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::GALLERY,
				'description' => esc_html__( 'Select images from media library', 'theaisle-core' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use &quot;full&quot; size', 'theaisle-core' )
			]
		);

		$this->add_control(
			'enable_image_shadow',
			[
				'label'     => esc_html__( 'Enable Image Shadow', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'theaisle-core'), 
					'yes' => esc_html__( 'Yes', 'theaisle-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'image_behavior',
			[
				'label'     => esc_html__( 'Image Behavior', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'None', 'theaisle-core'), 
					'custom-link' => esc_html__( 'Open Custom Link', 'theaisle-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'custom_links',
			[
				'label'     => esc_html__( 'Custom Links', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Delimit links by comma', 'theaisle-core' ),
				'condition' => [
					'image_behavior' => array( 'custom-link' )
				]
			]
		);

		$this->add_control(
			'custom_link_target',
			[
				'label'     => esc_html__( 'Custom Link Target', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'theaisle-core'), 
					'_blank' => esc_html__( 'New Window', 'theaisle-core')
				),
				'default' => '_self',
				'condition' => [
					'image_behavior' => array( 'custom-link' )
				]
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'huge' => esc_html__( 'Huge (40)', 'theaisle-core'), 
					'large' => esc_html__( 'Large (25)', 'theaisle-core'), 
					'medium' => esc_html__( 'Medium (20)', 'theaisle-core'), 
					'normal' => esc_html__( 'Normal (15)', 'theaisle-core'), 
					'small' => esc_html__( 'Small (10)', 'theaisle-core'), 
					'tiny' => esc_html__( 'Tiny (5)', 'theaisle-core'), 
					'no' => esc_html__( 'No (0)', 'theaisle-core')
				),
				'default' => 'normal'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_settings',
			[
				'label' => esc_html__( 'Slider Settings', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_visible_items',
			[
				'label'     => esc_html__( 'Number Of Visible Items', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'theaisle-core'), 
					'2' => esc_html__( 'Two', 'theaisle-core'), 
					'3' => esc_html__( 'Three', 'theaisle-core'), 
					'4' => esc_html__( 'Four', 'theaisle-core'), 
					'5' => esc_html__( 'Five', 'theaisle-core'), 
					'6' => esc_html__( 'Six', 'theaisle-core')
				),
				'default' => '1'
			]
		);

		$this->add_control(
			'slider_loop',
			[
				'label'     => esc_html__( 'Enable Slider Loop', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label'     => esc_html__( 'Enable Slider Autoplay', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_speed',
			[
				'label'     => esc_html__( 'Slide Duration', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default value is 5000 (ms)', 'theaisle-core' )
			]
		);

		$this->add_control(
			'slider_speed_animation',
			[
				'label'     => esc_html__( 'Slide Animation Duration', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 600.', 'theaisle-core' )
			]
		);

		$this->add_control(
			'slider_autowidth',
			[
				'label'     => esc_html__( 'Enable Slider Autowidth', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_navigation',
			[
				'label'     => esc_html__( 'Enable Slider Navigation Arrows', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'theaisle-core'), 
					'yes' => esc_html__( 'Yes', 'theaisle-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'slider_pagination',
			[
				'label'     => esc_html__( 'Enable Slider Pagination', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

        $params['holder_classes'] = $this->getHolderClasses( $params );
        $params['carousel_holder_classes'] = $this->getCarouselHolderClasses( $params );
        $params['slider_data']    = $this->getSliderData( $params );

        $params['type']               = ! empty( $params['type'] ) ? $params['type'] : 'text-left';
        $params['images']             = $this->getGalleryImages( $params );
        $params['image_size']         = $this->getImageSize( $params['image_size'] );
        $params['image_behavior']     = ! empty( $params['image_behavior'] ) ? $params['image_behavior'] : '';
        $params['custom_links']       = $this->getCustomLinks( $params );
        $params['custom_link_target'] = ! empty( $params['custom_link_target'] ) ? $params['custom_link_target'] : '_self';

        echo theaisle_core_get_shortcode_module_template_part( 'templates/' . $params['type'], 'image-carousel-with-text', '', $params );
	}

    private function getHolderClasses( $params ) {
        $holderClasses = array();

        $holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
        $holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-icwt-' . $params['type'] . '-type' : '';
        $holderClasses[] = $params['enable_image_shadow'] === 'yes' ? 'eltdf-has-shadow' : '';
        $holderClasses[] = ! empty( $params['image_behavior'] ) ? 'eltdf-image-behavior-' . $params['image_behavior'] : '';

        return implode( ' ', $holderClasses );
    }

    private function getCarouselHolderClasses( $params ) {
        $holderClasses = array();

        $holderClasses[] = ! empty( $params['space_between_items'] ) ? 'eltdf-' . $params['space_between_items'] . '-space' : '';

        return implode( ' ', $holderClasses );
    }

    private function getSliderData( $params ) {
        $slider_data = array();

        $slider_data['data-number-of-items']        = $params['number_of_visible_items'] !== '' ? $params['number_of_visible_items'] : '1';
        $slider_data['data-enable-loop']            = ! empty( $params['slider_loop'] ) ? $params['slider_loop'] : '';
        $slider_data['data-enable-autoplay']        = ! empty( $params['slider_autoplay'] ) ? $params['slider_autoplay'] : '';
        $slider_data['data-slider-speed']           = ! empty( $params['slider_speed'] ) ? $params['slider_speed'] : '5000';
        $slider_data['data-slider-speed-animation'] = ! empty( $params['slider_speed_animation'] ) ? $params['slider_speed_animation'] : '600';
        $slider_data['data-enable-navigation']      = ! empty( $params['slider_navigation'] ) ? $params['slider_navigation'] : '';
        $slider_data['data-enable-pagination']      = ! empty( $params['slider_pagination'] ) ? $params['slider_pagination'] : '';
        $slider_data['data-enable-rtl']             = $params['type'] === 'text-right' ? 'yes' : 'no';
        $slider_data['data-enable-auto-width']      = ! empty( $params['slider_autowidth'] ) ? $params['slider_autowidth'] : '';

        return $slider_data;
    }

    private function getGalleryImages( $params ) {
        $image_ids = array();
        $images    = array();
        $i         = 0;
        

        if ( $params['images'] !== '' ) {
        	foreach ($params['images'] as $single_image ) {
		        $image_ids[] = $single_image['id'];
	        }
        }

        foreach ( $image_ids as $id ) {

            $image['image_id'] = $id;
            $image_original    = wp_get_attachment_image_src( $id, 'full' );
            $image['url']      = $image_original[0];
            $image['title']    = get_the_title( $id );
            $image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );

            $images[ $i ] = $image;
            $i ++;
        }

        return $images;
    }

    private function getImageSize( $image_size ) {
        $image_size = trim( $image_size );
        //Find digits
        preg_match_all( '/\d+/', $image_size, $matches );
        if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ) ) ) {
            return $image_size;
        } elseif ( ! empty( $matches[0] ) ) {
            return array(
                $matches[0][0],
                $matches[0][1]
            );
        } else {
            return 'full';
        }
    }

    private function getCustomLinks( $params ) {
        $custom_links = array();

        if ( ! empty( $params['custom_links'] ) ) {
            $custom_links = array_map( 'trim', explode( ',', $params['custom_links'] ) );
        }

        return $custom_links;
    }

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorImageCarouselWithText() );