<?php
$i    = 0;
$rand = rand(0,1000);
?>
<div class="eltdf-icwt-holder <?php echo esc_attr($holder_classes); ?> clearfix">
    <div class="eltdf-icwt-img-side <?php echo esc_attr($carousel_holder_classes); ?>">
        <div class="eltdf-icwt-slider eltdf-owl-slider" <?php echo theaisle_elated_get_inline_attrs($slider_data); ?>>
            <?php foreach ($images as $image) { ?>
                <div class="eltdf-icwt-image">
                    <?php if ($image_behavior === 'custom-link' && !empty($custom_links)) { ?>
                    <a itemprop="url" class="eltdf-icwt-custom-link eltdf-block-drag-link" href="<?php echo esc_url($custom_links[$i++]); ?>" target="<?php echo esc_attr($custom_link_target); ?>" title="<?php echo esc_attr($image['title']); ?>">
                        <?php } ?>
                        <?php if(is_array($image_size) && count($image_size)) :
                            echo theaisle_elated_generate_thumbnail($image['image_id'], null, $image_size[0], $image_size[1]);
                        else:
                            echo wp_get_attachment_image($image['image_id'], $image_size);
                        endif; ?>
                        <?php if ($image_behavior === 'custom-link') { ?>
                    </a>
                <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="eltdf-icwt-text-side">
        <div class="eltdf-icwt-text-inner">
            <div class="eltdf-icwt-text-table">
                <?php if(!empty($title)) { ?>
                    <h2 class="eltdf-icwt-title">
                        <span class="eltdf-icwt-title-text"><?php echo esc_html($title); ?></span>
                    </h2>
                <?php } ?>
                <?php if(!empty($subtitle)) { ?>
                    <span class="eltdf-icwt-subtitle"><?php echo esc_html($subtitle); ?></span>
                <?php } ?>
                <?php if(!empty($text)) { ?>
                    <p class="eltdf-icwt-text"><?php echo esc_html($text); ?></p>
                <?php } ?>
            </div>
        </div>
    </div>
</div>