(function($) {
	'use strict';

	var imageGallery = {};
	eltdf.modules.imageGallery = imageGallery;
	
	imageGallery.eltdfInitImageGalleryCarouselResponsiveStyle = eltdfInitImageGalleryCarouselResponsiveStyle;
	
	
	imageGallery.eltdfOnDocumentReady = eltdfOnDocumentReady;

	$(document).ready(eltdfOnDocumentReady);
	$(window).on('load', eltdfOnWindowLoad);

	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnDocumentReady() {
		eltdfInitImageGalleryCarouselResponsiveStyle();
	}

	/**
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfElementorImageGallery();
		}
	
		/**
	 * Elementor
	 */
	function eltdfElementorImageGallery() {
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction('frontend/element_ready/eltdf_image_gallery.default', function () {
				eltdf.modules.common.eltdfOwlSlider();
				eltdf.modules.common.eltdfInitGridMasonryListLayout();
				eltdf.modules.common.eltdfPrettyPhoto();
				eltdfInitImageGalleryCarouselResponsiveStyle();
			});
		});
	}

	/*
	 **	Elements Holder responsive style
	 */
	function eltdfInitImageGalleryCarouselResponsiveStyle(){
		var imageGallery = $('.eltdf-image-gallery.eltdf-ig-carousel-type');

		if(imageGallery.length){
			imageGallery.each(function() {
				var thisImageGallery = $(this),
					imageGalleryItem = thisImageGallery.children('.eltdf-ig-slider'),
					style = '',
					responsiveStyle = '';
				
				imageGalleryItem.each(function() {
					var thisItem = $(this),
						ipadLandscape = '',
						mobileLandscape = '';
					
					
					if (typeof thisItem.data('768-1024') !== 'undefined' && thisItem.data('768-1024') !== false) {
						ipadLandscape = thisItem.data('768-1024');
					}
				
					if (typeof thisItem.data('767') !== 'undefined' && thisItem.data('767') !== false) {
						mobileLandscape = thisItem.data('767');
					}

					if( ipadLandscape.length || mobileLandscape.length ) {
						
						if(ipadLandscape.length) {
							responsiveStyle += "@media only screen and (min-width: 768px) and (max-width: 1024px) {.owl-stage-outer { height: "+ipadLandscape+" !important; } }";
						}
					
						if(mobileLandscape.length) {
							responsiveStyle += "@media only screen and (max-width: 767px) {.owl-stage-outer { height: "+mobileLandscape+" !important; } }";
						}
					}

                    if (typeof eltdf.modules.common.eltdfOwlSlider === "function") { // if owl function exist
                        var owl = thisItem.find('.eltdf-owl-slider');
                        if (owl.length) { // if owl is in elements holder
                            setTimeout(function () {
                                owl.trigger('refresh.owl.carousel'); // reinit owl
                            }, 100);
                        }
                    }

				});

				if(responsiveStyle.length) {
					style = '<style type="text/css">'+responsiveStyle+'</style>';
				}

				if(style.length) {
					$('head').append(style);
				}

			});
		}
	}

})(jQuery);