<?php
class TheAisleCoreElementorImageMarquee extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_image_marquee'; 
	}

	public function get_title() {
		return esc_html__( 'Image Marquee', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-image-marquee';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'theaisle-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {
		
		$params = $this->get_settings_for_display();
		$params['image'] = $params['image']['id'];
		
		echo theaisle_core_get_shortcode_module_template_part( 'templates/image-marquee-template', 'image-marquee', '', $params );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorImageMarquee() );