<?php

class TheAisleCoreElementorImageWithText extends \Elementor\Widget_Base {
	
	public function get_name() {
		return 'eltdf_image_with_text';
	}
	
	public function get_title() {
		return esc_html__( 'Image With Text', 'theaisle-core' );
	}
	
	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-image-with-text';
	}
	
	public function get_categories() {
		return [ 'elated' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'       => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
			]
		);
		
		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'theaisle-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'theaisle-core' )
			]
		);
		
		$this->add_control(
			'image_size',
			[
				'label'       => esc_html__( 'Image Size', 'theaisle-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use &quot;thumbnail&quot; size', 'theaisle-core' )
			]
		);
		
		$this->add_control(
			'enable_image_shadow',
			[
				'label'   => esc_html__( 'Enable Image Shadow', 'theaisle-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no'  => esc_html__( 'No', 'theaisle-core' ),
					'yes' => esc_html__( 'Yes', 'theaisle-core' )
				),
				'default' => 'no'
			]
		);
		
		$this->add_control(
			'image_behavior',
			[
				'label'   => esc_html__( 'Image Behavior', 'theaisle-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''            => esc_html__( 'None', 'theaisle-core' ),
					'lightbox'    => esc_html__( 'Open Lightbox', 'theaisle-core' ),
					'custom-link' => esc_html__( 'Open Custom Link', 'theaisle-core' ),
					'zoom'        => esc_html__( 'Zoom', 'theaisle-core' ),
					'grayscale'   => esc_html__( 'Grayscale', 'theaisle-core' )
				),
				'default' => ''
			]
		);
		
		$this->add_control(
			'custom_link',
			[
				'label'     => esc_html__( 'Custom Link', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'image_behavior' => array( 'custom-link' )
				]
			]
		);
		
		$this->add_control(
			'custom_link_target',
			[
				'label'     => esc_html__( 'Custom Link Target', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'_self'  => esc_html__( 'Same Window', 'theaisle-core' ),
					'_blank' => esc_html__( 'New Window', 'theaisle-core' )
				),
				'default'   => '_self',
				'condition' => [
					'image_behavior' => array( 'custom-link' )
				]
			]
		);
		
		$this->add_control(
			'alignment',
			[
				'label'   => esc_html__( 'Content Alignment', 'theaisle-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''       => esc_html__( 'Default', 'theaisle-core' ),
					'left'   => esc_html__( 'Left', 'theaisle-core' ),
					'right'  => esc_html__( 'Right', 'theaisle-core' ),
					'center' => esc_html__( 'Center', 'theaisle-core' )
				),
				'default' => 'left'
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''   => esc_html__( 'Default', 'theaisle-core' ),
					'h1' => esc_html__( 'h1', 'theaisle-core' ),
					'h2' => esc_html__( 'h2', 'theaisle-core' ),
					'h3' => esc_html__( 'h3', 'theaisle-core' ),
					'h4' => esc_html__( 'h4', 'theaisle-core' ),
					'h5' => esc_html__( 'h5', 'theaisle-core' ),
					'h6' => esc_html__( 'h6', 'theaisle-core' )
				),
				'default'   => 'h4',
				'condition' => [
					'title!' => ''
				]
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);
		
		$this->add_control(
			'title_top_margin',
			[
				'label'     => esc_html__( 'Title Top Margin (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'title!' => ''
				]
			]
		);
		
		$this->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::TEXTAREA
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'text!' => ''
				]
			]
		);
		
		$this->add_control(
			'text_top_margin',
			[
				'label'     => esc_html__( 'Text Top Margin (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);

        $this->add_control(
            'link_text1',
            [
                'label' => esc_html__( 'Link Text 1', 'theaisle-core' ),
                'type'  => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'link_text2',
            [
                'label' => esc_html__( 'Link Text 2', 'theaisle-core' ),
                'type'  => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'custom_link2',
            [
                'label'     => esc_html__( 'Custom Link 2', 'theaisle-core' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'image_behavior' => array( 'custom-link' )
                ]
            ]
        );

        $this->add_control(
            'custom_link_target2',
            [
                'label'     => esc_html__( 'Custom Link Target 2', 'theaisle-core' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => array(
                    '_self'  => esc_html__( 'Same Window', 'theaisle-core' ),
                    '_blank' => esc_html__( 'New Window', 'theaisle-core' )
                ),
                'default'   => '_self',
                'condition' => [
                    'image_behavior' => array( 'custom-link' )
                ]
            ]
        );
		
		$this->end_controls_section();
	}
	
	public function render() {
		
		$params = $this->get_settings_for_display();
		
		$params['holder_classes']     = $this->getHolderClasses( $params );
		$params['image']              = $this->getImage( $params );
		$params['image_size']         = $this->getImageSize( $params['image_size'] );
		$params['image_behavior']     = ! empty( $params['image_behavior'] ) ? $params['image_behavior'] : '';
		$params['custom_link_target'] = ! empty( $params['custom_link_target'] ) ? $params['custom_link_target'] : '_self';
		$params['title_tag']          = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h4';
		$params['title_styles']       = $this->getTitleStyles( $params );
		$params['text_styles']        = $this->getTextStyles( $params );
		$params['content_styles']     = $this->getContentStyles( $params );
		
		echo theaisle_core_get_shortcode_module_template_part( 'templates/image-with-text', 'image-with-text', '', $params );
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = $params['enable_image_shadow'] === 'yes' ? 'eltdf-has-shadow' : '';
		$holderClasses[] = ! empty( $params['image_behavior'] ) ? 'eltdf-image-behavior-' . $params['image_behavior'] : '';
        $holderClasses[] = ! empty( $params['link_text1'] ) ? 'eltdf-has-two-links' : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getImage( $params ) {
		$image = array();
		
		if ( ! empty( $params['image'] ) ) {
			$id = $params['image']['id'];
			
			$image['image_id'] = $id;
			$image_original    = wp_get_attachment_image_src( $id, 'full' );
			$image['url']      = $image_original[0];
			$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );
		}
		
		return $image;
	}
	
	private function getImageSize( $image_size ) {
		$image_size = trim( $image_size );
		//Find digits
		preg_match_all( '/\d+/', $image_size, $matches );
		if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ) ) ) {
			return $image_size;
		} elseif ( ! empty( $matches[0] ) ) {
			return array(
				$matches[0][0],
				$matches[0][1]
			);
		} else {
			return 'thumbnail';
		}
	}
	
	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		if ( $params['title_top_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . theaisle_elated_filter_px( $params['title_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
	
	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		if ( $params['text_top_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . theaisle_elated_filter_px( $params['text_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
	
	private function getContentStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['alignment'] ) ) {
			$styles[] = 'text-align: ' . $params['alignment'];
		}
		
		return implode( ';', $styles );
	}
	
}

\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorImageWithText() );