<div class="eltdf-image-with-text-holder <?php echo esc_attr($holder_classes); ?>">
    <div class="eltdf-iwt-image">
        <?php if (empty($link_text1)) { ?>
        <?php if ($image_behavior === 'lightbox') { ?>
            <a itemprop="image" href="<?php echo esc_url($image['url']); ?>" data-rel="prettyPhoto[iwt_pretty_photo]" title="<?php echo esc_attr($image['alt']); ?>">
        <?php } else if ($image_behavior === 'custom-link' && !empty($custom_link)) { ?>
	            <a itemprop="url" href="<?php echo esc_url($custom_link); ?>" target="<?php echo esc_attr($custom_link_target); ?>">
        <?php } ?>
        <?php } ?>
            <?php if(is_array($image_size) && count($image_size)) : ?>
                <?php echo theaisle_elated_generate_thumbnail($image['image_id'], null, $image_size[0], $image_size[1]); ?>
            <?php else: ?>
                <?php echo wp_get_attachment_image($image['image_id'], $image_size); ?>
            <?php endif; ?>
        <?php if ($image_behavior === 'lightbox' || $image_behavior === 'custom-link') { ?>
            </a>
        <?php } ?>
    </div>
    <div class="eltdf-iwt-text-holder" <?php echo theaisle_elated_get_inline_style($content_styles); ?>>
        <?php if(!empty($title)) { ?>
            <<?php echo esc_attr($title_tag); ?> class="eltdf-iwt-title" <?php echo theaisle_elated_get_inline_style($title_styles); ?>><?php echo esc_html($title); ?></<?php echo esc_attr($title_tag); ?>>
        <?php } ?>
		<?php if(!empty($text)) { ?>
            <p class="eltdf-iwt-text" <?php echo theaisle_elated_get_inline_style($text_styles); ?>><?php echo esc_html($text); ?></p>
        <?php } ?>
        <?php if(!empty($link_text1)) { ?>
            <div class="eltdf-itw-on-hover">
                <?php if ($image_behavior === 'custom-link' && !empty($custom_link)) { ?>
                <a itemprop="url" href="<?php echo esc_url($custom_link); ?>" target="<?php echo esc_attr($custom_link_target); ?>">
                <?php } ?>

                <p><?php echo esc_attr($link_text1); ?></p>

                <?php if ($image_behavior === 'custom-link' && !empty($custom_link)) { ?>
                </a>
                <?php } ?>

                <?php if ($image_behavior === 'custom-link' && !empty($custom_link)) { ?>
                <a itemprop="url" href="<?php echo esc_url($custom_link2); ?>" target="<?php echo esc_attr($custom_link_target2); ?>">
                <?php } ?>

                <p><?php echo esc_attr($link_text2); ?></p>

                <?php if ($image_behavior === 'custom-link' && !empty($custom_link2)) { ?>
                </a>
                <?php } ?>

            </div>
        <?php } ?>
    </div>
</div>