<?php
namespace TheAisleCore\CPT\Shortcodes\InfoBox;

use TheAisleCore\Lib;

class InfoBox implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'eltdf_info_box';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Info Box', 'theaisle-core' ),
					'base'                      => $this->base,
					'icon'                      => 'icon-wpb-info-box extended-custom-icon',
					'category'                  => esc_html__( 'by THEAISLE', 'theaisle-core' ),
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'shadow',
							'heading'     => esc_html__( 'Enable Shadow', 'theaisle-core' ),
							'value'       => array_flip( theaisle_elated_get_yes_no_select_array( false, true ) ),
							'save_always' => true
						),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'background_color',
                            'heading'    => esc_html__( 'Background Color', 'theaisle-core' )
                        ),
						array(
							'type'       => 'attach_image',
							'param_name' => 'custom_icon',
							'heading'    => esc_html__( 'Custom Icon', 'theaisle-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'custom_icon_size',
							'heading'    => esc_html__( 'Custom Icon Size (px)', 'theaisle-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'title',
							'heading'    => esc_html__( 'Title', 'theaisle-core' )
						),
						array(
							'type'       => 'textarea',
							'param_name' => 'text',
							'heading'    => esc_html__( 'Text', 'theaisle-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'link',
							'heading'     => esc_html__( 'Link', 'theaisle-core' ),
							'description' => esc_html__( 'Set link around icon and title', 'theaisle-core' ),
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'button_text',
							'heading'     => esc_html__( 'Button Text', 'theaisle-core' ),
							'description' => esc_html__( '', 'theaisle-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true ),
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'target',
							'heading'    => esc_html__( 'Target', 'theaisle-core' ),
							'value'      => array_flip( theaisle_elated_get_link_target_array() ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true ),
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$default_atts = array(
			'custom_class'                => '',
            'background_color'            => '',
			'custom_icon'                 => '',
			'custom_icon_size'            => '',
			'title'                       => '',
			'text'                        => '',
			'link'                        => '',
			'button_text'                 => '',
			'target'                      => '_self',
			'shadow'                      => '',
		);
		$params       = shortcode_atts( $default_atts, $atts );

		$params['holder_classes']  = $this->getHolderClasses( $params );
		$params['holder_styles']  = $this->getHolderStyles( $params );
		$params['target']          = ! empty( $params['target'] ) ? $params['target'] : $default_atts['target'];
		
		return theaisle_core_get_shortcode_module_template_part( 'templates/info-box', 'info-box', 'info-box', $params );
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array( 'eltdf-ib', 'clearfix' );
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = $params['shadow'] === 'yes' ? 'shadow-enabled' : '';

		return $holderClasses;
	}

    private function getHolderStyles( $params ) {
        $styles = array();

        if ( ! empty( $params['background_color'] ) ) {
            $styles[] = 'background-color: ' . $params['background_color'];
        }

        return implode( ';', $styles );
    }
}