<?php
class TheAisleCoreElementorInteractiveLinkShowcase extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_interactive_link_showcase'; 
	}

	public function get_title() {
		return esc_html__( 'Interactive Link Showcase', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-interactive-link-showcase';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Link Skin', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'light' => esc_html__( 'Light', 'theaisle-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'theaisle-core'), 
					'_blank' => esc_html__( 'New Window', 'theaisle-core')
				),
				'default' => '_self'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::GALLERY,
				'description' => esc_html__( 'Select image from media library', 'theaisle-core' )
			]
		);

		$this->add_control(
			'link_items',
			[
				'label'     => esc_html__( 'Link Items', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'theaisle-core' )
			]
		);

		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$params['holder_classes']      = $this->getHolderClasses( $params );
		$params['image_holder_styles'] = $this->getImageHolderStyles( $params );
		
		for ($i = 0; $i <= count($params['link_items']); $i++){
			if ( ! empty($params['link_items'][$i]['image'])) {
				$image_ids = array();
				foreach ($params['link_items'][$i]['image'] as $image ) {
					$image_ids[] = $image['id'];
				}
				$params['link_items'][$i]['image'] = implode(',', $image_ids);
			}
		}
		
		echo theaisle_core_get_shortcode_module_template_part( 'templates/interactive-link-showcase', 'interactive-link-showcase', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['skin'] ) ? 'eltdf-ils-skin-' . $params['skin'] : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getImageHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorInteractiveLinkShowcase() );