<?php
class TheAisleCoreElementorSectionTitle extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_section_title'; 
	}

	public function get_title() {
		return esc_html__( 'Section Title', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-section-title';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
			]
		);

		$this->add_control(
			'dots',
			[
				'label'     => esc_html__( 'Style with dots', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'position',
			[
				'label'     => esc_html__( 'Horizontal Position', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'left' => esc_html__( 'Left', 'theaisle-core'), 
					'center' => esc_html__( 'Center', 'theaisle-core'), 
					'right' => esc_html__( 'Right', 'theaisle-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'holder_padding',
			[
				'label'     => esc_html__( 'Holder Side Padding (px or %)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'icon_type',
			[
				'label'     => esc_html__( 'Icon Type', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'image' => esc_html__( 'Image', 'theaisle-core'), 
					'svg' => esc_html__( 'SVG', 'theaisle-core')
				),
				'default' => 'image'
			]
		);

		$this->add_control(
			'image',
			[
				'label'     => esc_html__( 'Top Image', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'theaisle-core' ),
				'condition' => [
					'icon_type' => array( 'image' )
				]
			]
		);

		$this->add_control(
			'svg',
			[
				'label'     => esc_html__( 'SVG Path Code', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'icon_type' => array( 'svg' )
				]
			]
		);

		$this->add_control(
			'image_margin',
			[
				'label'     => esc_html__( 'Image Bottom Margin (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title Style', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'h1' => esc_html__( 'h1', 'theaisle-core'), 
					'h2' => esc_html__( 'h2', 'theaisle-core'), 
					'h3' => esc_html__( 'h3', 'theaisle-core'), 
					'h4' => esc_html__( 'h4', 'theaisle-core'), 
					'h5' => esc_html__( 'h5', 'theaisle-core'), 
					'h6' => esc_html__( 'h6', 'theaisle-core')
				),
				'default' => 'h2',
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_break_words',
			[
				'label'     => esc_html__( 'Position of Line Break', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter the position of the word after which you would like to create a line break (e.g. if you would like the line break after the 3rd word, you would enter &quot;3&quot;)', 'theaisle-core' ),
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'disable_break_words',
			[
				'label'     => esc_html__( 'Disable Line Break for Smaller Screens', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'theaisle-core'), 
					'yes' => esc_html__( 'Yes', 'theaisle-core')
				),
				'default' => 'no',
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'text_tag',
			[
				'label'     => esc_html__( 'Text Tag', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'h1' => esc_html__( 'h1', 'theaisle-core'), 
					'h2' => esc_html__( 'h2', 'theaisle-core'), 
					'h3' => esc_html__( 'h3', 'theaisle-core'), 
					'h4' => esc_html__( 'h4', 'theaisle-core'), 
					'h5' => esc_html__( 'h5', 'theaisle-core'), 
					'h6' => esc_html__( 'h6', 'theaisle-core'), 
					'p' => esc_html__( 'p', 'theaisle-core'), 
					'span' => esc_html__( 'span', 'theaisle-core')
				),
				'default' => 'span',
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_font_size',
			[
				'label'     => esc_html__( 'Text Font Size (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_line_height',
			[
				'label'     => esc_html__( 'Text Line Height (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_font_weight',
			[
				'label'     => esc_html__( 'Text Font Weight', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'100' => esc_html__( '100 Thin', 'theaisle-core'), 
					'200' => esc_html__( '200 Thin-Light', 'theaisle-core'), 
					'300' => esc_html__( '300 Light', 'theaisle-core'), 
					'400' => esc_html__( '400 Normal', 'theaisle-core'), 
					'500' => esc_html__( '500 Medium', 'theaisle-core'), 
					'600' => esc_html__( '600 Semi-Bold', 'theaisle-core'), 
					'700' => esc_html__( '700 Bold', 'theaisle-core'), 
					'800' => esc_html__( '800 Extra-Bold', 'theaisle-core'), 
					'900' => esc_html__( '900 Ultra-Bold', 'theaisle-core')
				),
				'default' => '',
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_margin',
			[
				'label'     => esc_html__( 'Text Top Margin (px)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['holder_styles']  = $this->getHolderStyles( $params );
        $params['image']          = $this->getImage( $params );
        $params['image_styles']    = $this->getImageStyles( $params );
		$params['title']          = $this->getModifiedTitle( $params );
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h2';
		$params['title_styles']   = $this->getTitleStyles( $params );
		$params['text_tag']       = ! empty( $params['text_tag'] ) ? $params['text_tag'] : 'p';
		$params['text_styles']    = $this->getTextStyles( $params );
		
		echo theaisle_core_get_shortcode_module_template_part( 'templates/section-title', 'section-title', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = 'eltdf-st-standard';
		$holderClasses[] = $params['dots'] === 'yes' ? 'eltdf-st-with-dots' : '';
		$holderClasses[] = $params['disable_break_words'] === 'yes' ? 'eltdf-st-disable-title-break' : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['holder_padding'] ) ) {
			$styles[] = 'padding: 0 ' . $params['holder_padding'];
		}
		
		if ( ! empty( $params['position'] ) ) {
			$styles[] = 'text-align: ' . $params['position'];
		}
		
		return implode( ';', $styles );
	}

    private function getImage( $params ) {
        $image = array();

        if ( ! empty( $params['image'] ) ) {
            $id = $params['image']['id'];

            $image['image_id'] = $id;
            $image_original    = wp_get_attachment_image_src( $id, 'full' );
            $image['url']      = is_array( $image_original ) && isset( $image_original[0] ) ? $image_original[0] : '';
            $image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );
        }

        return $image;
    }

    private function getImageStyles( $params ) {
        $styles = array();

        if ( $params['image_margin'] !== '' ) {
            $styles[] = 'margin-bottom: ' . theaisle_elated_filter_px( $params['image_margin'] ) . 'px';
        }

        return implode( ';', $styles );
    }

	private function getModifiedTitle( $params ) {
		$title             = $params['title'];
		$title_break_words = str_replace( ' ', '', $params['title_break_words'] );
		
		if ( ! empty( $title ) ) {
			$split_title = explode( ' ', $title );
			$number_of_words = str_word_count($title, 0, '&');
			
			for($i=0; $i < $number_of_words; $i++) {
                if ( ! empty( $split_title[$i] ) ) {
                    $split_title[$i] = '<span class="eltdf-st-title-word">' . $split_title[$i] . '</span>';
                }
            }
            
			if ( ! empty( $title_break_words ) ) {
				if ( ! empty( $split_title[ $title_break_words - 1 ] ) ) {
					$split_title[ $title_break_words - 1 ] = $split_title[ $title_break_words - 1 ] . '<br />';
				}
			}
			
			$title = implode( ' ', $split_title );
		}
		
		return $title;
	}

	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		return implode( ';', $styles );
	}

	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		if ( ! empty( $params['text_font_size'] ) ) {
			$styles[] = 'font-size: ' . theaisle_elated_filter_px( $params['text_font_size'] ) . 'px';
		}
		
		if ( ! empty( $params['text_line_height'] ) ) {
			$styles[] = 'line-height: ' . theaisle_elated_filter_px( $params['text_line_height'] ) . 'px';
		}
		
		if ( ! empty( $params['text_font_weight'] ) ) {
			$styles[] = 'font-weight: ' . $params['text_font_weight'];
		}
		
		if ( $params['text_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . theaisle_elated_filter_px( $params['text_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorSectionTitle() );