<?php

if ( ! function_exists( 'theaisle_core_include_shortcodes_file' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function theaisle_core_include_shortcodes_file() {
		if ( theaisle_core_theme_installed() ) {
			foreach ( glob( THEAISLE_CORE_SHORTCODES_PATH . '/*/load.php' ) as $shortcode ) {
				if ( theaisle_elated_is_customizer_item_enabled( $shortcode, 'theaisle_performance_disable_shortcode_' ) ) {
					include_once $shortcode;
				}
			}
		}
		
		do_action( 'theaisle_core_action_include_shortcodes_file' );
	}
	
	add_action( 'init', 'theaisle_core_include_shortcodes_file', 6 ); // permission 6 is set to be before vc_before_init hook that has permission 9
}

if ( ! function_exists( 'theaisle_core_load_shortcodes' ) ) {
	function theaisle_core_load_shortcodes() {
		include_once THEAISLE_CORE_ABS_PATH . '/lib/shortcode-loader.php';
		
		TheAisleCore\Lib\ShortcodeLoader::getInstance()->load();
	}
	
	add_action( 'init', 'theaisle_core_load_shortcodes', 7 ); // permission 7 is set to be before vc_before_init hook that has permission 9 and after theaisle_core_include_shortcodes_file hook
}

if ( ! function_exists( 'theaisle_core_add_admin_shortcodes_styles' ) ) {
	/**
	 * Function that includes shortcodes core styles for admin
	 */
	function theaisle_core_add_admin_shortcodes_styles() {
		
		//include shortcode styles for Visual Composer
		wp_enqueue_style( 'theaisle-core-vc-shortcodes', THEAISLE_CORE_ASSETS_URL_PATH . '/css/admin/theaisle-vc-shortcodes.css' );
	}
	
	add_action( 'theaisle_elated_action_admin_scripts_init', 'theaisle_core_add_admin_shortcodes_styles' );
}

if ( ! function_exists( 'theaisle_core_add_admin_shortcodes_custom_styles' ) ) {
	/**
	 * Function that print custom vc shortcodes style
	 */
	function theaisle_core_add_admin_shortcodes_custom_styles() {
		$style                  = apply_filters( 'theaisle_core_filter_add_vc_shortcodes_custom_style', $style = '' );
		$shortcodes_icon_styles = array();
		$shortcode_icon_size    = 32;
		$shortcode_position     = 0;
		
		$shortcodes_icon_class_array = apply_filters( 'theaisle_core_filter_add_vc_shortcodes_custom_icon_class', $shortcodes_icon_class_array = array() );
		sort( $shortcodes_icon_class_array );
		
		if ( ! empty( $shortcodes_icon_class_array ) ) {
			foreach ( $shortcodes_icon_class_array as $shortcode_icon_class ) {
				$mark = $shortcode_position != 0 ? '-' : '';
				
				$shortcodes_icon_styles[] = '.vc_element-icon.extended-custom-icon' . esc_attr( $shortcode_icon_class ) . ' {
					background-position: ' . $mark . esc_attr( $shortcode_position * $shortcode_icon_size ) . 'px 0;
				}';
				
				$shortcode_position ++;
			}
		}
		
		if ( ! empty( $shortcodes_icon_styles ) ) {
			$style .= implode( ' ', $shortcodes_icon_styles );
		}
		
		if ( ! empty( $style ) ) {
			wp_add_inline_style( 'theaisle-core-vc-shortcodes', $style );
		}
	}
	
	add_action( 'theaisle_elated_action_admin_scripts_init', 'theaisle_core_add_admin_shortcodes_custom_styles' );
}

if ( ! function_exists( 'theaisle_core_load_elementor_shortcodes' ) ) {
	/**
	 * Function that loads elementor files inside shortcodes folder
	 */
	function theaisle_core_load_elementor_shortcodes() {
		if ( theaisle_core_theme_installed() && theaisle_elated_is_elementor_installed() ) {
			foreach ( glob( THEAISLE_CORE_SHORTCODES_PATH . '/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}
	
	if( defined( 'ELEMENTOR_VERSION' ) ) {
		if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
			add_action( 'elementor/widgets/register', 'theaisle_core_load_elementor_shortcodes' );
		} else {
			add_action( 'elementor/widgets/widgets_registered', 'theaisle_core_load_elementor_shortcodes' );
		}
	}
}

if ( ! function_exists( 'theaisle_core_add_elementor_widget_categories' ) ) {
	/**
	 * Registers category group
	 */
	function theaisle_core_add_elementor_widget_categories( $elements_manager ) {
		
		$elements_manager->add_category(
			'elated',
			[
				'title' => esc_html__( 'Elated', 'theaisle-core' ),
				'icon'  => 'fa fa-plug',
			]
		);
		
	}
	
	add_action( 'elementor/elements/categories_registered', 'theaisle_core_add_elementor_widget_categories' );
}

if( ! function_exists( 'theaisle_core_remove_widgets_for_elementor') ) {
	function theaisle_core_remove_widgets_for_elementor( $black_list ) {
		$black_list[] = 'TheAisleElatedClassAuthorInfoWidget';
		$black_list[] = 'TheAisleElatedClassBlogListWidget';
		$black_list[] = 'TheAisleElatedClassButtonWidget';
//		$black_list[] = 'TheAisleElatedClassContactForm7Widget';
		$black_list[] = 'TheAisleElatedClassCustomFontWidget';
		$black_list[] = 'TheAisleElatedClassIconWidget';
		$black_list[] = 'TheAisleElatedClassImageGalleryWidget';
//		$black_list[] = 'TheAisleInstagramWidget';
		$black_list[] = 'TheAisleTwitterWidget';
		$black_list[] = 'TheAisleElatedClassRecentPosts';
		$black_list[] = 'TheAisleElatedClassSearchOpener';
		$black_list[] = 'TheAisleElatedClassSearchPostType';
		$black_list[] = 'TheAisleElatedClassSeparatorWidget';
		$black_list[] = 'TheAisleElatedClassSideAreaOpener';
		$black_list[] = 'TheAisleElatedClassSocialIconWidget';
		$black_list[] = 'TheAisleElatedClassClassIconsGroupWidget';
		$black_list[] = 'TheAisleElatedClassStickySidebar';
		$black_list[] = 'TheAisleElatedClassWoocommerceDropdownCart';
		
		return $black_list;
	}
	
	add_filter('elementor/widgets/black_list', 'theaisle_core_remove_widgets_for_elementor');
}

if ( ! function_exists( 'theaisle_core_return_elementor_templates' ) ) {
	/**
	 * Function that returns all Elementor saved templates
	 */
	function theaisle_core_return_elementor_templates() {
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
}

if ( ! function_exists( 'theaisle_core_generate_elementor_templates_control' ) ) {
	/**
	 * Function that adds Template Elementor Control
	 */
	function theaisle_core_generate_elementor_templates_control( $object, $dependency_array = array() , $control_name = 'template_id' ) {
		$templates = theaisle_core_return_elementor_templates();
		
		if ( ! empty( $templates ) ) {
			$options = [
				'0' => '— ' . esc_html__( 'Select', 'theaisle-core' ) . ' —',
			];
			
			$types = [];
			
			foreach ( $templates as $template ) {
				$options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
				$types[ $template['template_id'] ]   = $template['type'];
			}
			
			$control_options_array = [
				'label'       => esc_html__( 'Choose Template', 'theaisle-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => $options,
				'types'       => $types,
				'label_block' => 'true'
			];
			
			if( is_array( $dependency_array ) && count( $dependency_array ) > 0 ){
				$control_options_array['condition'] = $dependency_array;
			}
			
			$object->add_control(
				$control_name, $control_options_array
			);
			
		};
	}
}

//function that maps "Anchor" option for section
if( ! function_exists('theaisle_core_map_section_anchor_option') ){
	function theaisle_core_map_section_anchor_option( $section, $args ){
		$section->start_controls_section(
			'section_elated_anchor',
			[
				'label' => esc_html__( 'TheAisle Anchor', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'anchor_id',
			[
				'label' => esc_html__( 'TheAisle Anchor ID', 'theaisle-core' ),
				'type'  => Elementor\Controls_Manager::TEXT,
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action('elementor/element/section/_section_responsive/after_section_end', 'theaisle_core_map_section_anchor_option', 10, 2);
}

//function that renders "Anchor" option for section
if( ! function_exists('theaisle_core_render_section_anchor_option') ) {
	function theaisle_core_render_section_anchor_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}
		
		$params = $element->get_settings_for_display();
		
		if( ! empty( $params['anchor_id'] ) ){
			$element->add_render_attribute( '_wrapper', 'data-eltdf-anchor', $params['anchor_id'] );
		}
	}
	
	add_action( 'elementor/frontend/section/before_render', 'theaisle_core_render_section_anchor_option');
}

//function that maps "Parallax" option for section
if ( ! function_exists( 'theaisle_core_map_section_parallax_option' ) ) {
	function theaisle_core_map_section_parallax_option( $section, $args ) {
		$section->start_controls_section(
			'section_elated_parallax',
			[
				'label' => esc_html__( 'TheAisle Parallax', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'elated_enable_parallax',
			[
				'label'        => esc_html__( 'Enable Parallax', 'theaisle-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'     => esc_html__( 'No', 'theaisle-core' ),
					'holder' => esc_html__( 'Yes', 'theaisle-core' ),
				],
				'prefix_class' => 'eltdf-parallax-row-'
			]
		);
		
		$section->add_control(
			'elated_parallax_image',
			[
				'label'              => esc_html__( 'Parallax Image', 'theaisle-core' ),
				'type'               => Elementor\Controls_Manager::MEDIA,
				'condition'          => [
					'elated_enable_parallax' => 'holder'
				],
				'frontend_available' => true,
			]
		);
		
		$section->add_control(
			'elated_parallax_speed',
			[
				'label'     => esc_html__( 'Parallax Speed', 'theaisle-core' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'elated_enable_parallax' => 'holder'
				],
				'default'   => '0'
			]
		);
		
		$section->add_control(
			'elated_parallax_height',
			[
				'label'     => esc_html__( 'Parallax Section Height (px)', 'theaisle-core' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'elated_enable_parallax' => 'holder'
				],
				'default'   => '0'
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'theaisle_core_map_section_parallax_option', 10, 2 );
}

//frontend function for "Parallax"
if ( ! function_exists( 'theaisle_core_render_section_parallax_option' ) ) {
	function theaisle_core_render_section_parallax_option( $element ) {
		if ( 'section' !== $element->get_name() ) {
			return;
		}
		
		$params = $element->get_settings_for_display();
		
		if ( ! empty( $params['elated_parallax_image']['id'] ) ) {
			$parallax_image_src = $params['elated_parallax_image']['url'];
			$parallax_speed     = ! empty( $params['elated_parallax_speed'] ) ? $params['elated_parallax_speed'] : '1';
			$parallax_height    = ! empty( $params['elated_parallax_height'] ) ? $params['elated_parallax_height'] : 0;
			
			$element->add_render_attribute( '_wrapper', 'class', 'eltdf-parallax-row-holder' );
			$element->add_render_attribute( '_wrapper', 'data-parallax-bg-speed', $parallax_speed );
			$element->add_render_attribute( '_wrapper', 'data-parallax-bg-image', $parallax_image_src );
			$element->add_render_attribute( '_wrapper', 'data-parallax-bg-height', $parallax_height );
		}
	}
	
	add_action( 'elementor/frontend/section/before_render', 'theaisle_core_render_section_parallax_option' );
}

//function that renders helper hidden input for parallax data attribute section
if ( ! function_exists( 'theaisle_core_generate_parallax_helper' ) ) {
	function theaisle_core_generate_parallax_helper( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {
			$template_preceding = "
            <# if( settings.elated_enable_parallax == 'holder' ){
		        let parallaxSpeed = settings.elated_parallax_speed !== '' ? settings.elated_parallax_speed : '0';
	            let parallaxImage = settings.elated_parallax_image.url !== '' ? settings.elated_parallax_image.url : '0'
	            let parallaxHeight = settings.elated_parallax_height !== '' ? settings.elated_parallax_height : '0'
	        #>
		        <input type='hidden' class='eltdf-parallax-helper-holder' data-parallax-bg-speed='{{ parallaxSpeed }}' data-parallax-bg-image='{{ parallaxImage }}' data-parallax-bg-height='{{ parallaxHeight }}'/>
		    <# } #>";
			$template           = $template_preceding . " " . $template;
		}
		
		return $template;
	}
	
	add_action( 'elementor/section/print_template', 'theaisle_core_generate_parallax_helper', 10, 2 );
}

//function that maps "Content Alignment" option for section
if ( ! function_exists( 'theaisle_core_map_section_content_alignment_option' ) ) {
	function theaisle_core_map_section_content_alignment_option( $section, $args ) {
		$section->start_controls_section(
			'elated_section_content_alignment',
			[
				'label' => esc_html__( 'TheAisle Content Alignment', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'elated_content_alignment',
			[
				'label'        => esc_html__( 'Content Alignment', 'theaisle-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'left',
				'options'      => [
					'left'   => esc_html__( 'Left', 'theaisle-core' ),
					'center' => esc_html__( 'Center', 'theaisle-core' ),
					'right'  => esc_html__( 'Right', 'theaisle-core' )
				],
				'prefix_class' => 'eltdf-content-aligment-'
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'theaisle_core_map_section_content_alignment_option', 10, 2 );
}

//function that maps "Grid" option for section
if ( ! function_exists( 'theaisle_core_map_section_grid_option' ) ) {
	function theaisle_core_map_section_grid_option( $section, $args ) {
		$section->start_controls_section(
			'elated_section_grid_row',
			[
				'label' => esc_html__( 'TheAisle Grid', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'elated_enable_grid_row',
			[
				'label'        => esc_html__( 'Make this row "In Grid"', 'theaisle-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'      => esc_html__( 'No', 'theaisle-core' ),
					'section' => esc_html__( 'Yes', 'theaisle-core' ),
				],
				'prefix_class' => 'eltdf-elementor-row-grid-'
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'theaisle_core_map_section_grid_option', 10, 2 );
}

//function that adds maps "Disable Background" option for section
if ( ! function_exists( 'theaisle_core_map_section_disable_background' ) ) {
	function theaisle_core_map_section_disable_background( $section, $args ) {
		$section->start_controls_section(
			'elated_section_disable_background',
			[
				'label' => esc_html__( 'TheAisle Disable Background Image', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'elated_disable_background',
			[
				'label'        => esc_html__( 'Disable row background', 'theaisle-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'   => esc_html__( 'Never', 'theaisle-core' ),
					'1280' => esc_html__( 'Below 1280px', 'theaisle-core' ),
					'1024' => esc_html__( 'Below 1024px', 'theaisle-core' ),
					'768'  => esc_html__( 'Below 768px', 'theaisle-core' ),
					'680'  => esc_html__( 'Below 680px', 'theaisle-core' ),
					'480'  => esc_html__( 'Below 480px', 'theaisle-core' )
				],
				'prefix_class' => 'eltdf-disabled-bg-image-bellow-'
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'theaisle_core_map_section_disable_background', 10, 2 );
}


if( ! function_exists('theaisle_core_elementor_icons_style') ){
	function theaisle_core_elementor_icons_style(){
		
		wp_enqueue_style( 'theaisle-core-elementor', THEAISLE_CORE_ASSETS_URL_PATH . '/css/admin/theaisle-elementor.css');
		
	}
	
	add_action( 'elementor/editor/before_enqueue_scripts', 'theaisle_core_elementor_icons_style' );
}


if ( ! function_exists( 'theaisle_core_get_elementor_shortcodes_path' ) ) {
	function theaisle_core_get_elementor_shortcodes_path() {
		$shortcodes       = array();
		$shortcodes_paths = array(
			THEAISLE_CORE_SHORTCODES_PATH . '/*' => THEAISLE_CORE_URL_PATH,
			THEAISLE_CORE_ABS_PATH . '/**/shortcodes/*' => THEAISLE_CORE_URL_PATH,
			THEAISLE_CORE_CPT_PATH . '/**/shortcodes/*' => THEAISLE_CORE_URL_PATH,
			THEAISLE_INSTAGRAM_SHORTCODES_PATH . '/*' => THEAISLE_INSTAGRAM_URL_PATH,
			THEAISLE_TWITTER_SHORTCODES_PATH . '/*' => THEAISLE_TWITTER_URL_PATH,
			ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/**/shortcodes/*' => ELATED_FRAMEWORK_ROOT . '/'
		);
		
		foreach ( $shortcodes_paths as $dir_path => $url_path ) {
			foreach ( glob( $dir_path, GLOB_ONLYDIR ) as $shortcode_dir_path ) {
				$shortcode_name     = basename( $shortcode_dir_path );
				$shortcode_url_path = $url_path . substr( $shortcode_dir_path, strpos( $shortcode_dir_path, basename( $url_path ) ) + strlen( basename( $url_path ) ) + 1 );
				
				$shortcodes[ $shortcode_name ] = array(
					'dir_path' => $shortcode_dir_path,
					'url_path' => $shortcode_url_path
				);
			}
		}
		
		return $shortcodes;
	}
}
if ( ! function_exists( 'theaisle_core_add_elementor_shortcodes_custom_styles' ) ) {
	function theaisle_core_add_elementor_shortcodes_custom_styles() {
		$style                  = '';
		$shortcodes_icon_styles = array();
		
		$shortcodes_icon_class_array = apply_filters( 'theaisle_core_filter_add_vc_shortcodes_custom_icon_class', $shortcodes_icon_class_array = array() );
		sort( $shortcodes_icon_class_array );
		
		$shortcodes_path = theaisle_core_get_elementor_shortcodes_path();
		if ( ! empty( $shortcodes_icon_class_array ) ) {
			foreach ( $shortcodes_icon_class_array as $shortcode_icon_class ) {
				
				$shortcode_name = str_replace( '.icon-wpb-', '', esc_attr( $shortcode_icon_class ) );
				
				if ( key_exists( $shortcode_name, $shortcodes_path ) && file_exists( $shortcodes_path[ $shortcode_name ]['dir_path'] . '/assets/img/dashboard_icon.png' ) ) {
					$shortcodes_icon_styles[] = '.theaisle-elementor-custom-icon.theaisle-elementor-' . $shortcode_name . ' {
                        background-image: url( "' . $shortcodes_path[ $shortcode_name ]['url_path'] . '/assets/img/dashboard_icon.png" );
                    }';
				}
			}
		}
		
		if ( ! empty( $shortcodes_icon_styles ) ) {
			$style = implode( ' ', $shortcodes_icon_styles );
		}
		if ( ! empty( $style ) ) {
			wp_add_inline_style( 'theaisle-core-elementor', $style );
		}
	}
	
	add_action( 'elementor/editor/before_enqueue_scripts', 'theaisle_core_add_elementor_shortcodes_custom_styles', 15 );
}