(function($) {
    'use strict';

    var simpleTimeline = {};
    eltdf.modules.simpleTimeline = simpleTimeline;

    simpleTimeline.eltdfInitSimpleTimeline = eltdfInitSimpleTimeline;


    simpleTimeline.eltdfOnDocumentReady = eltdfOnDocumentReady;

    $(document).ready(eltdfOnDocumentReady);
	$(window).on('load', eltdfOnWindowLoad);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function eltdfOnDocumentReady() {
        eltdfInitSimpleTimeline();
    }
	
	/**
	 All functions to be called on $(window).load() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfElementorSimpleTimeline();
	}
	
	/**
	 * Elementor
	 */
	function eltdfElementorSimpleTimeline(){
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/eltdf_simple_timeline.default', function() {
				eltdfInitSimpleTimeline();
			} );
		});
	}

    /**
     * Inti process shortcode on appear
     */
    function eltdfInitSimpleTimeline() {
        var holder = $('.eltdf-simple-timeline-holder');

        if(holder.length) {
            holder.each(function(){
                var thisHolder = $(this);
                var items = thisHolder.find('.eltdf-st-text-holder');

                thisHolder.appear(function(){
                    thisHolder.addClass('eltdf-simple-timeline-appeared');
                    setTimeout(function () {
                        items.each(function (i) {
                            var item = $(this);
                            setTimeout(function () {
                                item.addClass('eltdf-st-item-appeared');
                            }, 500 * i);
                        });
                    }, 350);
                },{accX: 0, accY: eltdfGlobalVars.vars.eltdfElementAppearAmount});
            });
        }

    }

})(jQuery);