<?php
class TheAisleCoreElementorSimpleTimeline extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_simple_timeline'; 
	}

	public function get_title() {
		return esc_html__( 'Simple Timeline', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-simple-timeline';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
			]
		);

		$this->add_control(
			'content_margin',
			[
				'label'     => esc_html__( 'Content Top And Bottom Margin', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'date',
			[
				'label'     => esc_html__( 'Date', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$this->add_control(
			'section_items',
			[
				'label'     => esc_html__( 'Sections', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'theaisle-core' )
			]
		);

		$this->add_control(
			'bottom_title',
			[
				'label'     => esc_html__( 'Bottom Title', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$params['holder_classes']  = $this->getHolderClasses( $params );
		$params['holder_styles']   = $this->getHolderStyles( $params );

		echo theaisle_core_get_shortcode_module_template_part( 'templates/simple-timeline', 'simple-timeline', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderStyles( $params ) {
		$holderStyles = array();

		$holderStyles[] = ! empty( $params['content_margin'] ) ? 'margin-top:-' . $params['content_margin'].';' : '';
		$holderStyles[] = ! empty( $params['content_margin'] ) ? 'margin-bottom: -' . $params['content_margin'] : '';

		return implode( ' ', $holderStyles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorSimpleTimeline() );