<?php
namespace TheAisleCore\CPT\Shortcodes\SimpleTimeline;

use TheAisleCore\Lib;

class SimpleTimeline implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'eltdf_simple_timeline';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Simple Timeline', 'theaisle-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by THEAISLE', 'theaisle-core' ),
					'icon'                      => 'icon-wpb-simple-timeline extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'theaisle-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'theaisle-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'content_margin',
							'heading'    => esc_html__( 'Content Top And Bottom Margin', 'theaisle-core' )
						),
						array(
							'type'       => 'param_group',
							'param_name' => 'section_items',
							'heading'    => esc_html__( 'Sections', 'masterds-core' ),
							'params'     => array(
								array(
									'type'       => 'textfield',
									'param_name' => 'title',
									'heading'    => esc_html__( 'Title', 'masterds-core' ),
								),
								array(
									'type'       => 'textfield',
									'param_name' => 'date',
									'heading'    => esc_html__( 'Date', 'masterds-core' )
								),
								array(
									'type'       => 'textarea',
									'param_name' => 'text',
									'heading'    => esc_html__( 'Text', 'masterds-core' )
								),
							)
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'bottom_title',
							'heading'    => esc_html__( 'Bottom Title', 'theaisle-core' )
						),
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'        => '',
			'content_margin'  => '',
			'bottom_title'        => '',
			'section_items'       => ''
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['holder_classes']  = $this->getHolderClasses( $params );
		$params['holder_styles']   = $this->getHolderStyles( $params );
		$params['section_items']   = json_decode( urldecode( $params['section_items'] ), true );

		$html = theaisle_core_get_shortcode_module_template_part( 'templates/simple-timeline', 'simple-timeline', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderStyles( $params ) {
		$holderStyles = array();

		$holderStyles[] = ! empty( $params['content_margin'] ) ? 'margin-top:-' . $params['content_margin'].';' : '';
		$holderStyles[] = ! empty( $params['content_margin'] ) ? 'margin-bottom: -' . $params['content_margin'] : '';

		return implode( ' ', $holderStyles );
	}
}