<?php

class TheAisleCoreElementorSplitSection extends \Elementor\Widget_Base {
	
	public function get_name() {
		return 'eltdf_split_section';
	}
	
	public function get_title() {
		return esc_html__( 'Split Section', 'theaisle-core' );
	}
	
	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-split-section';
	}
	
	public function get_categories() {
		return [ 'elated' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::MEDIA
			]
		);
		
		$this->add_control(
			'image_position',
			[
				'label'   => esc_html__( 'Image Position', 'theaisle-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'left'  => esc_html__( 'Left', 'theaisle-core' ),
					'right' => esc_html__( 'Right', 'theaisle-core' )
				),
				'default' => 'left'
			]
		);
		
		$this->add_control(
			'content_background',
			[
				'label' => esc_html__( 'Content Background Color', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''   => esc_html__( 'Default', 'theaisle-core' ),
					'h1' => esc_html__( 'h1', 'theaisle-core' ),
					'h2' => esc_html__( 'h2', 'theaisle-core' ),
					'h3' => esc_html__( 'h3', 'theaisle-core' ),
					'h4' => esc_html__( 'h4', 'theaisle-core' ),
					'h5' => esc_html__( 'h5', 'theaisle-core' ),
					'h6' => esc_html__( 'h6', 'theaisle-core' )
				),
				'default'   => 'h2',
				'condition' => [
					'title!' => ''
				]
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);
		
		$this->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'text_tag',
			[
				'label'     => esc_html__( 'Text Tag', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''   => esc_html__( 'Default', 'theaisle-core' ),
					'h1' => esc_html__( 'h1', 'theaisle-core' ),
					'h2' => esc_html__( 'h2', 'theaisle-core' ),
					'h3' => esc_html__( 'h3', 'theaisle-core' ),
					'h4' => esc_html__( 'h4', 'theaisle-core' ),
					'h5' => esc_html__( 'h5', 'theaisle-core' ),
					'h6' => esc_html__( 'h6', 'theaisle-core' ),
					'p'  => esc_html__( 'p', 'theaisle-core' )
				),
				'default'   => 'h5',
				'condition' => [
					'text!' => ''
				]
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'text!' => ''
				]
			]
		);
		
		$this->add_control(
			'text_top_margin',
			[
				'label'     => esc_html__( 'Text Top Margin (px or %)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button Text', 'theaisle-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'breakpoint',
			[
				'label'       => esc_html__( 'Responsive Breakpoint', 'theaisle-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Choose on which stage you want to break image and text content to be one under other', 'theaisle-core' ),
				'options'     => array(
					''     => esc_html__( 'Never', 'theaisle-core' ),
					'1366' => esc_html__( 'Below 1366px', 'theaisle-core' ),
					'1024' => esc_html__( 'Below 1024px', 'theaisle-core' ),
					'768'  => esc_html__( 'Below 768px', 'theaisle-core' ),
					'680'  => esc_html__( 'Below 680px', 'theaisle-core' ),
					'480'  => esc_html__( 'Below 480px', 'theaisle-core' )
				),
				'default'     => ''
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__( 'Button Style', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'button_type',
			[
				'label'     => esc_html__( 'Button Type', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'solid'   => esc_html__( 'Solid', 'theaisle-core' ),
					'outline' => esc_html__( 'Outline', 'theaisle-core' ),
					'simple'  => esc_html__( 'Text', 'theaisle-core' )
				),
				'default'   => 'outline',
				'condition' => [
					'button_text!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_size',
			[
				'label'     => esc_html__( 'Button Size', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''       => esc_html__( 'Default', 'theaisle-core' ),
					'small'  => esc_html__( 'Small', 'theaisle-core' ),
					'medium' => esc_html__( 'Medium', 'theaisle-core' ),
					'large'  => esc_html__( 'Large', 'theaisle-core' ),
					'huge'   => esc_html__( 'Huge', 'theaisle-core' )
				),
				'default'   => 'normal',
				'condition' => [
					'button_text!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_link',
			[
				'label'     => esc_html__( 'Button Link', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'button_text!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_target',
			[
				'label'     => esc_html__( 'Button Link Target', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'_self'  => esc_html__( 'Same Window', 'theaisle-core' ),
					'_blank' => esc_html__( 'New Window', 'theaisle-core' )
				),
				'default'   => '_self',
				'condition' => [
					'button_link!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_color',
			[
				'label'     => esc_html__( 'Button Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'button_text!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_background_color',
			[
				'label'     => esc_html__( 'Button Background Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'button_type' => array( 'solid' )
				]
			]
		);
		
		$this->add_control(
			'button_border_color',
			[
				'label'     => esc_html__( 'Button Border Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'button_text!' => ''
				]
			]
		);
		
		$this->add_control(
			'button_top_margin',
			[
				'label'     => esc_html__( 'Button Top Margin (px or %)', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'button_text!' => ''
				]
			]
		);
		
		$this->end_controls_section();
	}
	
	public function render() {
		
		$params = $this->get_settings_for_display();
		
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['content_style']  = $this->getContentStyles( $params );
		$params['image_styles']   = $this->getImageBackgroundStyles( $params );
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h2';
		$params['title_styles']   = $this->getTitleStyles( $params );
		$params['text_tag']       = ! empty( $params['text_tag'] ) ? $params['text_tag'] : 'h5';
		$params['text_styles']    = $this->getTextStyles( $params );
		
		echo theaisle_core_get_shortcode_module_template_part( 'templates/split-section', 'split-section', '', $params );
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = 'eltdf-ss-image-' . $params['image_position'];
		$holderClasses[] = ! empty( $params['breakpoint'] ) ? 'eltdf-ss-break-' . $params['breakpoint'] : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getImageBackgroundStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['image'] ) ) {
			$params['image'] = $params['image']['id'];
			$image_src       = wp_get_attachment_image_src( $params['image'], 'full' );
			
			if ( is_array( $image_src ) ) {
				$image_src = $image_src[0];
			}
			
			$styles[] = 'background-image: url(' . $image_src . ')';
		}
		
		return implode( ';', $styles );
	}
	
	private function getContentStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['content_background'] ) ) {
			$styles[] = 'background-color:' . $params['content_background'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		if ( $params['text_top_margin'] !== '' ) {
			if ( theaisle_elated_string_ends_with( $params['text_top_margin'], '%' ) || theaisle_elated_string_ends_with( $params['text_top_margin'], 'px' ) ) {
				$styles[] = 'margin-top: ' . $params['width'];
			} else {
				$styles[] = 'margin-top: ' . $params['text_top_margin'] . 'px';
			}
		}
		
		return implode( ';', $styles );
	}
	
}

\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorSplitSection() );