<?php
class TheAisleCoreElementorTeamCarousel extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_team_carousel'; 
	}

	public function get_title() {
		return esc_html__( 'Team Carousel', 'theaisle-core' );
	}

	public function get_icon() {
		return 'theaisle-elementor-custom-icon theaisle-elementor-team-carousel';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'theaisle-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_visible_items',
			[
				'label'     => esc_html__( 'Number of Visible Items', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'theaisle-core'), 
					'2' => esc_html__( 'Two', 'theaisle-core'), 
					'3' => esc_html__( 'Three', 'theaisle-core'), 
					'4' => esc_html__( 'Four', 'theaisle-core'), 
					'5' => esc_html__( 'Five', 'theaisle-core'), 
					'6' => esc_html__( 'Six', 'theaisle-core')
				),
				'default' => '3'
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'huge' => esc_html__( 'Huge (40)', 'theaisle-core'), 
					'large' => esc_html__( 'Large (25)', 'theaisle-core'), 
					'medium' => esc_html__( 'Medium (20)', 'theaisle-core'), 
					'normal' => esc_html__( 'Normal (15)', 'theaisle-core'), 
					'small' => esc_html__( 'Small (10)', 'theaisle-core'), 
					'tiny' => esc_html__( 'Tiny (5)', 'theaisle-core'), 
					'no' => esc_html__( 'No (0)', 'theaisle-core')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'slider_loop',
			[
				'label'     => esc_html__( 'Enable Slider Loop', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label'     => esc_html__( 'Enable Slider Autoplay', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_speed',
			[
				'label'     => esc_html__( 'Slide Duration', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default value is 5000 (ms)', 'theaisle-core' )
			]
		);

		$this->add_control(
			'slider_speed_animation',
			[
				'label'     => esc_html__( 'Slide Animation Duration', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 600.', 'theaisle-core' )
			]
		);

		$this->add_control(
			'slider_navigation',
			[
				'label'     => esc_html__( 'Enable Slider Navigation Arrows', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_pagination',
			[
				'label'     => esc_html__( 'Enable Slider Pagination', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'theaisle-core'), 
					'no' => esc_html__( 'No', 'theaisle-core')
				),
				'default' => 'yes'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'info-below-image' => esc_html__( 'Info Below Image', 'theaisle-core'), 
					'info-on-image' => esc_html__( 'Info On Image Hover', 'theaisle-core')
				),
				'default' => 'info-below-image'
			]
		);

		$repeater->add_control(
			'team_image',
			[
				'label'     => esc_html__( 'Image', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Image should have 1:1 ratio', 'theaisle-core' )
			]
		);

		$repeater->add_control(
			'team_name',
			[
				'label'     => esc_html__( 'Name', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'team_name_tag',
			[
				'label'     => esc_html__( 'Name Tag', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'theaisle-core'), 
					'h1' => esc_html__( 'h1', 'theaisle-core'), 
					'h2' => esc_html__( 'h2', 'theaisle-core'), 
					'h3' => esc_html__( 'h3', 'theaisle-core'), 
					'h4' => esc_html__( 'h4', 'theaisle-core'), 
					'h5' => esc_html__( 'h5', 'theaisle-core'), 
					'h6' => esc_html__( 'h6', 'theaisle-core'), 
					'span' => esc_html__( 'span', 'theaisle-core')
				),
				'default' => '',
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_name_color',
			[
				'label'     => esc_html__( 'Name Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_position',
			[
				'label'     => esc_html__( 'Position', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'team_position_color',
			[
				'label'     => esc_html__( 'Position Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_position!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_text',
			[
				'label'     => esc_html__( 'Text', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'team_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_text!' => ''
				]
			]
		);
		
		$repeater->add_control(
			'team_social_icon_pack',
			[
				'type'        => \Elementor\Controls_Manager::SELECT,
				'label'         => esc_html__( 'Social Icon Pack', 'theaisle-core' ),
				'options'       => array_flip(array_merge( array( '' => '' ), theaisle_elated_icon_collections()->getIconCollectionsVCExclude( array('linea_icons', 'linear_icons') ) )),
				'condition' => [
					'textual_social_icons' => 'no'
				]
			]
		);
		
		for ( $x = 1; $x < 6; $x ++ ) {
			$teamIconCollections = theaisle_elated_icon_collections()->getCollectionsWithSocialIcons();
			foreach ( $teamIconCollections as $collection_key => $collection ) {
				
				$repeater->add_control(
					'team_social_' . $collection->param . '_' . $x,
					[
						'type'       => \Elementor\Controls_Manager::SELECT,
						'label'    => esc_html__( 'Social Icon ', 'theaisle-core' ) . $x,
						'options'  => array_flip($collection->getSocialIconsArrayVC()),
						'condition' => [
							'team_social_icon_pack' => array( $collection_key )
						]
					]
				);
			}
			$repeater->add_control(
				'team_social_icon_' . $x . '_link',
				[
					'type'       => \Elementor\Controls_Manager::TEXT,
					'label'      => esc_html__( 'Social Icon ', 'theaisle-core' ) . $x . esc_html__( ' Link', 'theaisle-core' ),
					'condition' => [
						'team_social_icon_pack' => theaisle_elated_icon_collections()->getIconCollectionsKeys()
					]
				]
			);
			
			$repeater->add_control(
				'team_social_icon_' . $x . '_target',
				[
					'type'       => \Elementor\Controls_Manager::SELECT,
					'label'    => esc_html__( 'Social Icon ', 'theaisle-core' ) . $x . esc_html__( ' Target', 'theaisle-core' ),
					'options'      => array(
						'_self' => esc_html__( 'Same Window', 'theaisle-core' ),
						'_blank' => esc_html__( 'New Window', 'theaisle-core' )
					),
					'condition' => [
						'team_social_icon_' . $x . '_link!' => ''
					]
				]
			);
			
		}
		
		$this->add_control(
			'team_item',
			[
				'label'     => esc_html__( 'Team', 'theaisle-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'theaisle-core' )
			]
		);
		
		
		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$holder_classes = $this->getHolderClasses( $params );
		$slider_data    = $this->getSliderData( $params );
		?>
		
		<div class="eltdf-team-carousel-holder <?php echo esc_attr( $holder_classes ); ?>">
			<div class="eltdf-tc-inner eltdf-owl-slider" <?php echo theaisle_elated_get_inline_attrs( $slider_data ) ?>>
				<?php foreach ( $params['team_item'] as $team ) {
					
					$team['type']                 = ! empty( $params['type'] ) ? $params['type'] : 'info-below-image';
					$team['team_image']           = ! empty($team['team_image']) ? $team['team_image']['id'] : $team['team_image'];
					$team['holder_classes']       = $this->getItemHolderClasses( $team );
					$team['team_name_tag']        = ! empty( $params['team_name_tag'] ) ? $params['team_name_tag'] : 'h3';
					$team['team_social_icons']    = $this->getItemTeamSocialIcons( $team );
					$team['team_name_styles']     = $this->getItemTeamNameStyles( $team );
					$team['team_position_styles'] = $this->getItemTeamPositionStyles( $team );
					$team['team_text_styles']     = $this->getItemTeamTextStyles( $team );
					
					echo theaisle_core_get_shortcode_module_template_part( 'templates/'. $team['type'], 'team', '', $team );
				} ?>
			</div>
		</div>
		
		<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'eltdf-' . $params['space_between_items'] . '-space' : 'eltdf-' . $args['space_between_items'] . '-space';
		
		return implode( ' ', $holderClasses );
	}

	private function getSliderData( $params ) {
		$slider_data = array();
		
		$slider_data['data-number-of-items']        = $params['number_of_visible_items'] !== '' ? $params['number_of_visible_items'] : '3';
		$slider_data['data-enable-loop']            = ! empty( $params['slider_loop'] ) ? $params['slider_loop'] : '';
		$slider_data['data-enable-autoplay']        = ! empty( $params['slider_autoplay'] ) ? $params['slider_autoplay'] : '';
		$slider_data['data-slider-speed']           = ! empty( $params['slider_speed'] ) ? $params['slider_speed'] : '5000';
		$slider_data['data-slider-speed-animation'] = ! empty( $params['slider_speed_animation'] ) ? $params['slider_speed_animation'] : '600';
		$slider_data['data-enable-navigation']      = ! empty( $params['slider_navigation'] ) ? $params['slider_navigation'] : '';
		$slider_data['data-enable-pagination']      = ! empty( $params['slider_pagination'] ) ? $params['slider_pagination'] : '';
		
		return $slider_data;
	}
	
	private function getItemHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-team-' . $params['type'] : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getItemTeamSocialIcons( $params ) {
		$team_social_icons = array();
		
		if ( $params['social_type'] == 'social-icon' && !empty($params['social_icon_item'])) {
			
			foreach ( $params['social_icon_item'] as $icon ) {
				
				$iconPackName = theaisle_elated_icon_collections()->getIconCollectionParamNameByKey( $icon['icon_pack'] );
				
				$team_icon_params                  = array();
				$team_icon_params['icon_pack']     = $icon['icon_pack'];
				$team_icon_params[ $iconPackName ] = $icon[ $iconPackName ];
				$team_icon_params['link']          = $icon['team_social_icon_link'];
				$team_icon_params['target']        = $icon['team_social_icon_target'];
				
				$team_social_icons[] = theaisle_elated_execute_shortcode( 'eltdf_icon', $team_icon_params );
			}
		}
		
		return $team_social_icons;
	}
	
	private function getItemTeamNameStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['team_name_color'] ) ) {
			$styles[] = 'color: ' . $params['team_name_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getItemTeamPositionStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['team_position_color'] ) ) {
			$styles[] = 'color: ' . $params['team_position_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getItemTeamTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['team_text_color'] ) ) {
			$styles[] = 'color: ' . $params['team_text_color'];
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new TheAisleCoreElementorTeamCarousel() );